/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.organizations.model.OrganizationFeatureSet;
import com.amazonaws.services.organizations.model.PolicyTypeSummary;
import com.amazonaws.services.organizations.model.transform.OrganizationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Organization
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private String featureSet;
    private String masterAccountArn;
    private String masterAccountId;
    private String masterAccountEmail;
    private List<PolicyTypeSummary> availablePolicyTypes;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Organization withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Organization withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setFeatureSet(String featureSet) {
        this.featureSet = featureSet;
    }

    public String getFeatureSet() {
        return this.featureSet;
    }

    public Organization withFeatureSet(String featureSet) {
        this.setFeatureSet(featureSet);
        return this;
    }

    public void setFeatureSet(OrganizationFeatureSet featureSet) {
        this.withFeatureSet(featureSet);
    }

    public Organization withFeatureSet(OrganizationFeatureSet featureSet) {
        this.featureSet = featureSet.toString();
        return this;
    }

    public void setMasterAccountArn(String masterAccountArn) {
        this.masterAccountArn = masterAccountArn;
    }

    public String getMasterAccountArn() {
        return this.masterAccountArn;
    }

    public Organization withMasterAccountArn(String masterAccountArn) {
        this.setMasterAccountArn(masterAccountArn);
        return this;
    }

    public void setMasterAccountId(String masterAccountId) {
        this.masterAccountId = masterAccountId;
    }

    public String getMasterAccountId() {
        return this.masterAccountId;
    }

    public Organization withMasterAccountId(String masterAccountId) {
        this.setMasterAccountId(masterAccountId);
        return this;
    }

    public void setMasterAccountEmail(String masterAccountEmail) {
        this.masterAccountEmail = masterAccountEmail;
    }

    public String getMasterAccountEmail() {
        return this.masterAccountEmail;
    }

    public Organization withMasterAccountEmail(String masterAccountEmail) {
        this.setMasterAccountEmail(masterAccountEmail);
        return this;
    }

    public List<PolicyTypeSummary> getAvailablePolicyTypes() {
        return this.availablePolicyTypes;
    }

    public void setAvailablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
        if (availablePolicyTypes == null) {
            this.availablePolicyTypes = null;
            return;
        }
        this.availablePolicyTypes = new ArrayList<PolicyTypeSummary>(availablePolicyTypes);
    }

    public Organization withAvailablePolicyTypes(PolicyTypeSummary ... availablePolicyTypes) {
        if (this.availablePolicyTypes == null) {
            this.setAvailablePolicyTypes(new ArrayList<PolicyTypeSummary>(availablePolicyTypes.length));
        }
        for (PolicyTypeSummary ele : availablePolicyTypes) {
            this.availablePolicyTypes.add(ele);
        }
        return this;
    }

    public Organization withAvailablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
        this.setAvailablePolicyTypes(availablePolicyTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getFeatureSet() != null) {
            sb.append("FeatureSet: ").append(this.getFeatureSet()).append(",");
        }
        if (this.getMasterAccountArn() != null) {
            sb.append("MasterAccountArn: ").append(this.getMasterAccountArn()).append(",");
        }
        if (this.getMasterAccountId() != null) {
            sb.append("MasterAccountId: ").append(this.getMasterAccountId()).append(",");
        }
        if (this.getMasterAccountEmail() != null) {
            sb.append("MasterAccountEmail: ").append(this.getMasterAccountEmail()).append(",");
        }
        if (this.getAvailablePolicyTypes() != null) {
            sb.append("AvailablePolicyTypes: ").append(this.getAvailablePolicyTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getFeatureSet() == null ^ this.getFeatureSet() == null) {
            return false;
        }
        if (other.getFeatureSet() != null && !other.getFeatureSet().equals(this.getFeatureSet())) {
            return false;
        }
        if (other.getMasterAccountArn() == null ^ this.getMasterAccountArn() == null) {
            return false;
        }
        if (other.getMasterAccountArn() != null && !other.getMasterAccountArn().equals(this.getMasterAccountArn())) {
            return false;
        }
        if (other.getMasterAccountId() == null ^ this.getMasterAccountId() == null) {
            return false;
        }
        if (other.getMasterAccountId() != null && !other.getMasterAccountId().equals(this.getMasterAccountId())) {
            return false;
        }
        if (other.getMasterAccountEmail() == null ^ this.getMasterAccountEmail() == null) {
            return false;
        }
        if (other.getMasterAccountEmail() != null && !other.getMasterAccountEmail().equals(this.getMasterAccountEmail())) {
            return false;
        }
        if (other.getAvailablePolicyTypes() == null ^ this.getAvailablePolicyTypes() == null) {
            return false;
        }
        return other.getAvailablePolicyTypes() == null || other.getAvailablePolicyTypes().equals(this.getAvailablePolicyTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureSet() == null ? 0 : this.getFeatureSet().hashCode());
        hashCode = 31 * hashCode + (this.getMasterAccountArn() == null ? 0 : this.getMasterAccountArn().hashCode());
        hashCode = 31 * hashCode + (this.getMasterAccountId() == null ? 0 : this.getMasterAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getMasterAccountEmail() == null ? 0 : this.getMasterAccountEmail().hashCode());
        hashCode = 31 * hashCode + (this.getAvailablePolicyTypes() == null ? 0 : this.getAvailablePolicyTypes().hashCode());
        return hashCode;
    }

    public Organization clone() {
        try {
            return (Organization)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

