/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.EnvironmentLink;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EnvironmentLinkStaxUnmarshaller
implements Unmarshaller<EnvironmentLink, StaxUnmarshallerContext> {
    private static EnvironmentLinkStaxUnmarshaller instance;

    @Override
    public EnvironmentLink unmarshall(StaxUnmarshallerContext context) throws Exception {
        EnvironmentLink environmentLink = new EnvironmentLink();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return environmentLink;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LinkName", targetDepth)) {
                    environmentLink.setLinkName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EnvironmentName", targetDepth)) continue;
                environmentLink.setEnvironmentName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return environmentLink;
    }

    public static EnvironmentLinkStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EnvironmentLinkStaxUnmarshaller();
        }
        return instance;
    }
}

