/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.config.model.ResourceType;
import com.amazonaws.services.config.model.transform.RecordingGroupMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RecordingGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean allSupported;
    private Boolean includeGlobalResourceTypes;
    private SdkInternalList<String> resourceTypes;

    public void setAllSupported(Boolean allSupported) {
        this.allSupported = allSupported;
    }

    public Boolean getAllSupported() {
        return this.allSupported;
    }

    public RecordingGroup withAllSupported(Boolean allSupported) {
        this.setAllSupported(allSupported);
        return this;
    }

    public Boolean isAllSupported() {
        return this.allSupported;
    }

    public void setIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
        this.includeGlobalResourceTypes = includeGlobalResourceTypes;
    }

    public Boolean getIncludeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public RecordingGroup withIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
        this.setIncludeGlobalResourceTypes(includeGlobalResourceTypes);
        return this;
    }

    public Boolean isIncludeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public List<String> getResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new SdkInternalList();
        }
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new SdkInternalList<String>(resourceTypes);
    }

    public RecordingGroup withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new SdkInternalList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public RecordingGroup withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public RecordingGroup withResourceTypes(ResourceType ... resourceTypes) {
        SdkInternalList<String> resourceTypesCopy = new SdkInternalList<String>(resourceTypes.length);
        for (ResourceType value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllSupported() != null) {
            sb.append("AllSupported: ").append(this.getAllSupported()).append(",");
        }
        if (this.getIncludeGlobalResourceTypes() != null) {
            sb.append("IncludeGlobalResourceTypes: ").append(this.getIncludeGlobalResourceTypes()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingGroup)) {
            return false;
        }
        RecordingGroup other = (RecordingGroup)obj;
        if (other.getAllSupported() == null ^ this.getAllSupported() == null) {
            return false;
        }
        if (other.getAllSupported() != null && !other.getAllSupported().equals(this.getAllSupported())) {
            return false;
        }
        if (other.getIncludeGlobalResourceTypes() == null ^ this.getIncludeGlobalResourceTypes() == null) {
            return false;
        }
        if (other.getIncludeGlobalResourceTypes() != null && !other.getIncludeGlobalResourceTypes().equals(this.getIncludeGlobalResourceTypes())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        return other.getResourceTypes() == null || other.getResourceTypes().equals(this.getResourceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllSupported() == null ? 0 : this.getAllSupported().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeGlobalResourceTypes() == null ? 0 : this.getIncludeGlobalResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        return hashCode;
    }

    public RecordingGroup clone() {
        try {
            return (RecordingGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

