/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.MetricDatapoint;
import java.util.Date;

@SdkInternalApi
public class MetricDatapointMarshaller {
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("average").build();
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximum").build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimum").build();
    private static final MarshallingInfo<Double> SAMPLECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleCount").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").build();
    private static final MetricDatapointMarshaller instance = new MetricDatapointMarshaller();

    public static MetricDatapointMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDatapoint metricDatapoint, ProtocolMarshaller protocolMarshaller) {
        if (metricDatapoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metricDatapoint.getAverage(), AVERAGE_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getMaximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getMinimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getSampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getSum(), SUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(metricDatapoint.getUnit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

