/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch.spi;

import com.amazonaws.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;

public enum AWSMetricTransformerFactory {
    DynamoDB;

    private static final String REQUEST_TRANSFORMER_CLASSNAME_SUFFIX = "RequestMetricTransformer";
    public static final String DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE = "com.amazonaws.metrics.internal.cloudwatch.provider.transform";
    public static volatile String transformerPackage;
    private volatile RequestMetricTransformer requestMetricTransformer;

    public static String getTransformerPackage() {
        return transformerPackage;
    }

    public static void setTransformerPackage(String transformPackage) {
        if (transformPackage == null) {
            throw new IllegalArgumentException();
        }
        transformerPackage = transformPackage;
    }

    public static String buildRequestMetricTransformerFQCN(String awsPrefix, String packageName) {
        return packageName + "." + awsPrefix + REQUEST_TRANSFORMER_CLASSNAME_SUFFIX;
    }

    private RequestMetricTransformer loadRequestMetricTransformer(String fqcn) {
        Log log = LogFactory.getLog(AWSMetricTransformerFactory.class);
        if (log.isDebugEnabled()) {
            log.debug("Loading " + fqcn);
        }
        try {
            Class<?> c = Class.forName(fqcn);
            return (RequestMetricTransformer)c.newInstance();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to load " + fqcn + "; therefore ignoring " + this.name() + " specific predefined metrics", e);
            }
            return RequestMetricTransformer.NONE;
        }
    }

    public RequestMetricTransformer getRequestMetricTransformer() {
        RequestMetricTransformer transformer = this.requestMetricTransformer;
        String packageName = transformerPackage;
        if (transformer != null && packageName.equals(transformer.getClass().getPackage().getName())) {
            return transformer;
        }
        String fqcn = AWSMetricTransformerFactory.buildRequestMetricTransformerFQCN(this.name(), packageName);
        this.requestMetricTransformer = this.loadRequestMetricTransformer(fqcn);
        return this.requestMetricTransformer;
    }

    static {
        transformerPackage = DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE;
    }
}

