/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.ScheduleLambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionClient;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.LambdaFunctionCompletedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.LambdaFunctionFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.LambdaFunctionStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.LambdaFunctionTimedOutEventAttributes;
import com.amazonaws.services.simpleworkflow.model.ScheduleLambdaFunctionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.ScheduleLambdaFunctionFailedEventAttributes;
import java.util.HashMap;
import java.util.Map;

public class LambdaFunctionClientImpl
implements LambdaFunctionClient {
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<String, String>> scheduledLambdas = new HashMap<String, OpenRequestInfo<String, String>>();

    public LambdaFunctionClientImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input) {
        return this.scheduleLambdaFunction(name, input, 0L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, Promise<String> input) {
        return this.scheduleLambdaFunction(name, input, 0L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(final String name, final Promise<String> input, final long timeoutSeconds) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(LambdaFunctionClientImpl.this.scheduleLambdaFunction(name, (String)input.get(), timeoutSeconds));
            }
        };
        return result;
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input, long timeoutSeconds) {
        if (timeoutSeconds < 0L) {
            throw new IllegalArgumentException("Negative timeoutSeconds: " + timeoutSeconds);
        }
        final OpenRequestInfo context = new OpenRequestInfo(name);
        final ScheduleLambdaFunctionDecisionAttributes attributes = new ScheduleLambdaFunctionDecisionAttributes();
        attributes.setName(name);
        attributes.setInput(input);
        final String functionId = this.decisions.getNextId();
        attributes.setId(functionId);
        if (timeoutSeconds == 0L) {
            attributes.setStartToCloseTimeout(FlowHelpers.secondsToDuration(300L));
        } else {
            attributes.setStartToCloseTimeout(FlowHelpers.secondsToDuration(timeoutSeconds));
        }
        String taskName = "functionId=" + attributes.getId() + ", timeouts=" + attributes.getStartToCloseTimeout();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                LambdaFunctionClientImpl.this.decisions.scheduleLambdaFunction(attributes);
                context.setCompletionHandle(handle);
                LambdaFunctionClientImpl.this.scheduledLambdas.put(functionId, context);
                return new LambdaFunctionCancellationHandler(functionId);
            }
        }.setName(taskName);
        context.setResultDescription("createTimer " + taskName);
        return context.getResult();
    }

    void handleLambdaFunctionStarted(LambdaFunctionStartedEventAttributes attributes) {
    }

    void handleScheduleLambdaFunctionFailed(HistoryEvent event) {
        ScheduleLambdaFunctionFailedEventAttributes attributes = event.getScheduleLambdaFunctionFailedEventAttributes();
        String functionId = attributes.getId();
        OpenRequestInfo<String, String> scheduled = this.scheduledLambdas.remove(functionId);
        if (this.decisions.handleScheduleLambdaFunctionFailed(event)) {
            String cause = attributes.getCause();
            ScheduleLambdaFunctionFailedException failure = new ScheduleLambdaFunctionFailedException(event.getEventId(), attributes.getName(), functionId, cause);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleLambdaFunctionCompleted(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionCompletedEventAttributes attributes = event.getLambdaFunctionCompletedEventAttributes();
        String lambdaId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(lambdaId) && (scheduled = this.scheduledLambdas.remove(lambdaId)) != null) {
            String result = attributes.getResult();
            scheduled.getResult().set(result);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.complete();
        }
    }

    void handleLambdaFunctionFailed(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionFailedEventAttributes attributes = event.getLambdaFunctionFailedEventAttributes();
        String functionId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(functionId) && (scheduled = this.scheduledLambdas.remove(functionId)) != null) {
            String detail = attributes.getDetails();
            LambdaFunctionFailedException failure = new LambdaFunctionFailedException(event.getEventId(), scheduled.getUserContext(), functionId, detail);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleLambdaFunctionTimedOut(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionTimedOutEventAttributes attributes = event.getLambdaFunctionTimedOutEventAttributes();
        String functionId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(functionId) && (scheduled = this.scheduledLambdas.remove(functionId)) != null) {
            String timeoutType = attributes.getTimeoutType();
            LambdaFunctionTimedOutException failure = new LambdaFunctionTimedOutException(event.getEventId(), scheduled.getUserContext(), functionId, timeoutType);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    private final class LambdaFunctionCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String lambdaId;

        private LambdaFunctionCancellationHandler(String lambdaId) {
            this.lambdaId = lambdaId;
        }

        @Override
        public void handleCancellation(Throwable cause) {
        }
    }
}

