/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.AWSSessionCredentials;

@SdkInternalApi
public class AWSSessionCredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyId").build();
    private static final MarshallingInfo<String> SECRETACCESSKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretAccessKey").build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionToken").build();
    private static final AWSSessionCredentialsMarshaller instance = new AWSSessionCredentialsMarshaller();

    public static AWSSessionCredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(AWSSessionCredentials aWSSessionCredentials, ProtocolMarshaller protocolMarshaller) {
        if (aWSSessionCredentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(aWSSessionCredentials.getAccessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall(aWSSessionCredentials.getSecretAccessKey(), SECRETACCESSKEY_BINDING);
            protocolMarshaller.marshall(aWSSessionCredentials.getSessionToken(), SESSIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

