/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import java.util.Date;

@SdkInternalApi
public class FileSystemDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").build();
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Integer> NUMBEROFMOUNTTARGETS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfMountTargets").build();
    private static final MarshallingInfo<StructuredPojo> SIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").build();
    private static final FileSystemDescriptionMarshaller instance = new FileSystemDescriptionMarshaller();

    public static FileSystemDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileSystemDescription fileSystemDescription, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(fileSystemDescription.getOwnerId(), OWNERID_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getCreationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getFileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getLifeCycleState(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getNumberOfMountTargets(), NUMBEROFMOUNTTARGETS_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getSizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getPerformanceMode(), PERFORMANCEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

