/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearch;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearchClientBuilder;
import com.amazonaws.services.cloudsearchv2.model.AmazonCloudSearchException;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesRequest;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.transform.BaseExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DisabledOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonCloudSearchClient
extends AmazonWebServiceClient
implements AmazonCloudSearch {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCloudSearch.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudsearch";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonCloudSearchClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonCloudSearchClientBuilder builder() {
        return AmazonCloudSearchClientBuilder.standard();
    }

    AmazonCloudSearchClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new DisabledOperationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BaseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller(AmazonCloudSearchException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://cloudsearch.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudsearchv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudsearchv2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildSuggestersResult buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(buildSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BuildSuggestersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BuildSuggestersRequestMarshaller().marshall(super.beforeMarshalling(buildSuggestersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<BuildSuggestersResult> responseHandler = new StaxResponseHandler<BuildSuggestersResult>(new BuildSuggestersResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BuildSuggestersResult buildSuggestersResult = (BuildSuggestersResult)response.getAwsResponse();
            return buildSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResult createDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDomainRequestMarshaller().marshall(super.beforeMarshalling(createDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<CreateDomainResult> responseHandler = new StaxResponseHandler<CreateDomainResult>(new CreateDomainResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDomainResult createDomainResult = (CreateDomainResult)response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineAnalysisSchemeResult defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineAnalysisSchemeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineAnalysisSchemeRequestMarshaller().marshall(super.beforeMarshalling(defineAnalysisSchemeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DefineAnalysisSchemeResult> responseHandler = new StaxResponseHandler<DefineAnalysisSchemeResult>(new DefineAnalysisSchemeResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DefineAnalysisSchemeResult defineAnalysisSchemeResult = (DefineAnalysisSchemeResult)response.getAwsResponse();
            return defineAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineExpressionResult defineExpression(DefineExpressionRequest defineExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineExpressionRequestMarshaller().marshall(super.beforeMarshalling(defineExpressionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DefineExpressionResult> responseHandler = new StaxResponseHandler<DefineExpressionResult>(new DefineExpressionResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DefineExpressionResult defineExpressionResult = (DefineExpressionResult)response.getAwsResponse();
            return defineExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineIndexFieldResult defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineIndexFieldRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineIndexFieldRequestMarshaller().marshall(super.beforeMarshalling(defineIndexFieldRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DefineIndexFieldResult> responseHandler = new StaxResponseHandler<DefineIndexFieldResult>(new DefineIndexFieldResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DefineIndexFieldResult defineIndexFieldResult = (DefineIndexFieldResult)response.getAwsResponse();
            return defineIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineSuggesterResult defineSuggester(DefineSuggesterRequest defineSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DefineSuggesterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DefineSuggesterRequestMarshaller().marshall(super.beforeMarshalling(defineSuggesterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DefineSuggesterResult> responseHandler = new StaxResponseHandler<DefineSuggesterResult>(new DefineSuggesterResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DefineSuggesterResult defineSuggesterResult = (DefineSuggesterResult)response.getAwsResponse();
            return defineSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnalysisSchemeResult deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAnalysisSchemeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAnalysisSchemeRequestMarshaller().marshall(super.beforeMarshalling(deleteAnalysisSchemeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DeleteAnalysisSchemeResult> responseHandler = new StaxResponseHandler<DeleteAnalysisSchemeResult>(new DeleteAnalysisSchemeResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAnalysisSchemeResult deleteAnalysisSchemeResult = (DeleteAnalysisSchemeResult)response.getAwsResponse();
            return deleteAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDomainRequestMarshaller().marshall(super.beforeMarshalling(deleteDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DeleteDomainResult> responseHandler = new StaxResponseHandler<DeleteDomainResult>(new DeleteDomainResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDomainResult deleteDomainResult = (DeleteDomainResult)response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExpressionResult deleteExpression(DeleteExpressionRequest deleteExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteExpressionRequestMarshaller().marshall(super.beforeMarshalling(deleteExpressionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DeleteExpressionResult> responseHandler = new StaxResponseHandler<DeleteExpressionResult>(new DeleteExpressionResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteExpressionResult deleteExpressionResult = (DeleteExpressionResult)response.getAwsResponse();
            return deleteExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexFieldResult deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIndexFieldRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIndexFieldRequestMarshaller().marshall(super.beforeMarshalling(deleteIndexFieldRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DeleteIndexFieldResult> responseHandler = new StaxResponseHandler<DeleteIndexFieldResult>(new DeleteIndexFieldResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIndexFieldResult deleteIndexFieldResult = (DeleteIndexFieldResult)response.getAwsResponse();
            return deleteIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSuggesterResult deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSuggesterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSuggesterRequestMarshaller().marshall(super.beforeMarshalling(deleteSuggesterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DeleteSuggesterResult> responseHandler = new StaxResponseHandler<DeleteSuggesterResult>(new DeleteSuggesterResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSuggesterResult deleteSuggesterResult = (DeleteSuggesterResult)response.getAwsResponse();
            return deleteSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnalysisSchemesResult describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAnalysisSchemesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAnalysisSchemesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAnalysisSchemesRequestMarshaller().marshall(super.beforeMarshalling(describeAnalysisSchemesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeAnalysisSchemesResult> responseHandler = new StaxResponseHandler<DescribeAnalysisSchemesResult>(new DescribeAnalysisSchemesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAnalysisSchemesResult describeAnalysisSchemesResult = (DescribeAnalysisSchemesResult)response.getAwsResponse();
            return describeAnalysisSchemesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAvailabilityOptionsResult describeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAvailabilityOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAvailabilityOptionsRequestMarshaller().marshall(super.beforeMarshalling(describeAvailabilityOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeAvailabilityOptionsResult> responseHandler = new StaxResponseHandler<DescribeAvailabilityOptionsResult>(new DescribeAvailabilityOptionsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAvailabilityOptionsResult describeAvailabilityOptionsResult = (DescribeAvailabilityOptionsResult)response.getAwsResponse();
            return describeAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainsResult describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainsRequestMarshaller().marshall(super.beforeMarshalling(describeDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeDomainsResult> responseHandler = new StaxResponseHandler<DescribeDomainsResult>(new DescribeDomainsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDomainsResult describeDomainsResult = (DescribeDomainsResult)response.getAwsResponse();
            return describeDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDomainsResult describeDomains() {
        return this.describeDomains(new DescribeDomainsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExpressionsResult describeExpressions(DescribeExpressionsRequest describeExpressionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExpressionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeExpressionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeExpressionsRequestMarshaller().marshall(super.beforeMarshalling(describeExpressionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeExpressionsResult> responseHandler = new StaxResponseHandler<DescribeExpressionsResult>(new DescribeExpressionsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeExpressionsResult describeExpressionsResult = (DescribeExpressionsResult)response.getAwsResponse();
            return describeExpressionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIndexFieldsResult describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIndexFieldsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIndexFieldsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIndexFieldsRequestMarshaller().marshall(super.beforeMarshalling(describeIndexFieldsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeIndexFieldsResult> responseHandler = new StaxResponseHandler<DescribeIndexFieldsResult>(new DescribeIndexFieldsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeIndexFieldsResult describeIndexFieldsResult = (DescribeIndexFieldsResult)response.getAwsResponse();
            return describeIndexFieldsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingParametersResult describeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScalingParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScalingParametersRequestMarshaller().marshall(super.beforeMarshalling(describeScalingParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeScalingParametersResult> responseHandler = new StaxResponseHandler<DescribeScalingParametersResult>(new DescribeScalingParametersResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeScalingParametersResult describeScalingParametersResult = (DescribeScalingParametersResult)response.getAwsResponse();
            return describeScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceAccessPoliciesResult describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServiceAccessPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServiceAccessPoliciesRequestMarshaller().marshall(super.beforeMarshalling(describeServiceAccessPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeServiceAccessPoliciesResult> responseHandler = new StaxResponseHandler<DescribeServiceAccessPoliciesResult>(new DescribeServiceAccessPoliciesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServiceAccessPoliciesResult describeServiceAccessPoliciesResult = (DescribeServiceAccessPoliciesResult)response.getAwsResponse();
            return describeServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSuggestersResult describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSuggestersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSuggestersRequestMarshaller().marshall(super.beforeMarshalling(describeSuggestersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DescribeSuggestersResult> responseHandler = new StaxResponseHandler<DescribeSuggestersResult>(new DescribeSuggestersResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSuggestersResult describeSuggestersResult = (DescribeSuggestersResult)response.getAwsResponse();
            return describeSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDocumentsResult indexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(indexDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IndexDocumentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IndexDocumentsRequestMarshaller().marshall(super.beforeMarshalling(indexDocumentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<IndexDocumentsResult> responseHandler = new StaxResponseHandler<IndexDocumentsResult>(new IndexDocumentsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            IndexDocumentsResult indexDocumentsResult = (IndexDocumentsResult)response.getAwsResponse();
            return indexDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResult listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainNamesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainNamesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainNamesRequestMarshaller().marshall(super.beforeMarshalling(listDomainNamesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<ListDomainNamesResult> responseHandler = new StaxResponseHandler<ListDomainNamesResult>(new ListDomainNamesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainNamesResult listDomainNamesResult = (ListDomainNamesResult)response.getAwsResponse();
            return listDomainNamesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainNamesResult listDomainNames() {
        return this.listDomainNames(new ListDomainNamesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAvailabilityOptionsResult updateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAvailabilityOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAvailabilityOptionsRequestMarshaller().marshall(super.beforeMarshalling(updateAvailabilityOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<UpdateAvailabilityOptionsResult> responseHandler = new StaxResponseHandler<UpdateAvailabilityOptionsResult>(new UpdateAvailabilityOptionsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAvailabilityOptionsResult updateAvailabilityOptionsResult = (UpdateAvailabilityOptionsResult)response.getAwsResponse();
            return updateAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScalingParametersResult updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateScalingParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateScalingParametersRequestMarshaller().marshall(super.beforeMarshalling(updateScalingParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<UpdateScalingParametersResult> responseHandler = new StaxResponseHandler<UpdateScalingParametersResult>(new UpdateScalingParametersResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateScalingParametersResult updateScalingParametersResult = (UpdateScalingParametersResult)response.getAwsResponse();
            return updateScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceAccessPoliciesResult updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceAccessPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceAccessPoliciesRequestMarshaller().marshall(super.beforeMarshalling(updateServiceAccessPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<UpdateServiceAccessPoliciesResult> responseHandler = new StaxResponseHandler<UpdateServiceAccessPoliciesResult>(new UpdateServiceAccessPoliciesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceAccessPoliciesResult updateServiceAccessPoliciesResult = (UpdateServiceAccessPoliciesResult)response.getAwsResponse();
            return updateServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

