/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.AppType;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CreateAppRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackId;
    private String shortname;
    private String name;
    private String description;
    private SdkInternalList<DataSource> dataSources;
    private String type;
    private Source appSource;
    private SdkInternalList<String> domains;
    private Boolean enableSsl;
    private SslConfiguration sslConfiguration;
    private SdkInternalMap<String, String> attributes;
    private SdkInternalList<EnvironmentVariable> environment;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public CreateAppRequest withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getShortname() {
        return this.shortname;
    }

    public CreateAppRequest withShortname(String shortname) {
        this.setShortname(shortname);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAppRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAppRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<DataSource> getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = new SdkInternalList();
        }
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new SdkInternalList<DataSource>(dataSources);
    }

    public CreateAppRequest withDataSources(DataSource ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new SdkInternalList<DataSource>(dataSources.length));
        }
        for (DataSource ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public CreateAppRequest withDataSources(Collection<DataSource> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateAppRequest withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(AppType type) {
        this.type = type.toString();
    }

    public CreateAppRequest withType(AppType type) {
        this.setType(type);
        return this;
    }

    public void setAppSource(Source appSource) {
        this.appSource = appSource;
    }

    public Source getAppSource() {
        return this.appSource;
    }

    public CreateAppRequest withAppSource(Source appSource) {
        this.setAppSource(appSource);
        return this;
    }

    public List<String> getDomains() {
        if (this.domains == null) {
            this.domains = new SdkInternalList();
        }
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        this.domains = new SdkInternalList<String>(domains);
    }

    public CreateAppRequest withDomains(String ... domains) {
        if (this.domains == null) {
            this.setDomains(new SdkInternalList<String>(domains.length));
        }
        for (String ele : domains) {
            this.domains.add(ele);
        }
        return this;
    }

    public CreateAppRequest withDomains(Collection<String> domains) {
        this.setDomains(domains);
        return this;
    }

    public void setEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    public Boolean getEnableSsl() {
        return this.enableSsl;
    }

    public CreateAppRequest withEnableSsl(Boolean enableSsl) {
        this.setEnableSsl(enableSsl);
        return this;
    }

    public Boolean isEnableSsl() {
        return this.enableSsl;
    }

    public void setSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public CreateAppRequest withSslConfiguration(SslConfiguration sslConfiguration) {
        this.setSslConfiguration(sslConfiguration);
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new SdkInternalMap<String, String>(attributes);
    }

    public CreateAppRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public CreateAppRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new SdkInternalMap();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public CreateAppRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<EnvironmentVariable> getEnvironment() {
        if (this.environment == null) {
            this.environment = new SdkInternalList();
        }
        return this.environment;
    }

    public void setEnvironment(Collection<EnvironmentVariable> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new SdkInternalList<EnvironmentVariable>(environment);
    }

    public CreateAppRequest withEnvironment(EnvironmentVariable ... environment) {
        if (this.environment == null) {
            this.setEnvironment(new SdkInternalList<EnvironmentVariable>(environment.length));
        }
        for (EnvironmentVariable ele : environment) {
            this.environment.add(ele);
        }
        return this;
    }

    public CreateAppRequest withEnvironment(Collection<EnvironmentVariable> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getShortname() != null) {
            sb.append("Shortname: ").append(this.getShortname()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getAppSource() != null) {
            sb.append("AppSource: ").append(this.getAppSource()).append(",");
        }
        if (this.getDomains() != null) {
            sb.append("Domains: ").append(this.getDomains()).append(",");
        }
        if (this.getEnableSsl() != null) {
            sb.append("EnableSsl: ").append(this.getEnableSsl()).append(",");
        }
        if (this.getSslConfiguration() != null) {
            sb.append("SslConfiguration: ").append(this.getSslConfiguration()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getShortname() == null ^ this.getShortname() == null) {
            return false;
        }
        if (other.getShortname() != null && !other.getShortname().equals(this.getShortname())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAppSource() == null ^ this.getAppSource() == null) {
            return false;
        }
        if (other.getAppSource() != null && !other.getAppSource().equals(this.getAppSource())) {
            return false;
        }
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !other.getDomains().equals(this.getDomains())) {
            return false;
        }
        if (other.getEnableSsl() == null ^ this.getEnableSsl() == null) {
            return false;
        }
        if (other.getEnableSsl() != null && !other.getEnableSsl().equals(this.getEnableSsl())) {
            return false;
        }
        if (other.getSslConfiguration() == null ^ this.getSslConfiguration() == null) {
            return false;
        }
        if (other.getSslConfiguration() != null && !other.getSslConfiguration().equals(this.getSslConfiguration())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getShortname() == null ? 0 : this.getShortname().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAppSource() == null ? 0 : this.getAppSource().hashCode());
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        hashCode = 31 * hashCode + (this.getEnableSsl() == null ? 0 : this.getEnableSsl().hashCode());
        hashCode = 31 * hashCode + (this.getSslConfiguration() == null ? 0 : this.getSslConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    @Override
    public CreateAppRequest clone() {
        return (CreateAppRequest)super.clone();
    }
}

