/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.NetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.NetworkInterfaceIpv6Address;
import com.amazonaws.services.ec2.model.NetworkInterfacePrivateIpAddress;
import com.amazonaws.services.ec2.model.NetworkInterfaceStatus;
import com.amazonaws.services.ec2.model.NetworkInterfaceType;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NetworkInterface
implements Serializable,
Cloneable {
    private String networkInterfaceId;
    private String subnetId;
    private String vpcId;
    private String availabilityZone;
    private String description;
    private String ownerId;
    private String requesterId;
    private Boolean requesterManaged;
    private String status;
    private String macAddress;
    private String privateIpAddress;
    private String privateDnsName;
    private Boolean sourceDestCheck;
    private SdkInternalList<GroupIdentifier> groups;
    private NetworkInterfaceAttachment attachment;
    private NetworkInterfaceAssociation association;
    private SdkInternalList<Tag> tagSet;
    private SdkInternalList<NetworkInterfacePrivateIpAddress> privateIpAddresses;
    private SdkInternalList<NetworkInterfaceIpv6Address> ipv6Addresses;
    private String interfaceType;

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public NetworkInterface withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NetworkInterface withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public NetworkInterface withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public NetworkInterface withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public NetworkInterface withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public NetworkInterface withRequesterId(String requesterId) {
        this.setRequesterId(requesterId);
        return this;
    }

    public void setRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
    }

    public Boolean getRequesterManaged() {
        return this.requesterManaged;
    }

    public NetworkInterface withRequesterManaged(Boolean requesterManaged) {
        this.setRequesterManaged(requesterManaged);
        return this;
    }

    public Boolean isRequesterManaged() {
        return this.requesterManaged;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public NetworkInterface withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(NetworkInterfaceStatus status) {
        this.status = status.toString();
    }

    public NetworkInterface withStatus(NetworkInterfaceStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public NetworkInterface withMacAddress(String macAddress) {
        this.setMacAddress(macAddress);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public NetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public NetworkInterface withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public NetworkInterface withSourceDestCheck(Boolean sourceDestCheck) {
        this.setSourceDestCheck(sourceDestCheck);
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new SdkInternalList();
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new SdkInternalList<GroupIdentifier>(groups);
    }

    public NetworkInterface withGroups(GroupIdentifier ... groups) {
        if (this.groups == null) {
            this.setGroups(new SdkInternalList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public NetworkInterface withGroups(Collection<GroupIdentifier> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setAttachment(NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
    }

    public NetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public NetworkInterface withAttachment(NetworkInterfaceAttachment attachment) {
        this.setAttachment(attachment);
        return this;
    }

    public void setAssociation(NetworkInterfaceAssociation association) {
        this.association = association;
    }

    public NetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public NetworkInterface withAssociation(NetworkInterfaceAssociation association) {
        this.setAssociation(association);
        return this;
    }

    public List<Tag> getTagSet() {
        if (this.tagSet == null) {
            this.tagSet = new SdkInternalList();
        }
        return this.tagSet;
    }

    public void setTagSet(Collection<Tag> tagSet) {
        if (tagSet == null) {
            this.tagSet = null;
            return;
        }
        this.tagSet = new SdkInternalList<Tag>(tagSet);
    }

    public NetworkInterface withTagSet(Tag ... tagSet) {
        if (this.tagSet == null) {
            this.setTagSet(new SdkInternalList<Tag>(tagSet.length));
        }
        for (Tag ele : tagSet) {
            this.tagSet.add(ele);
        }
        return this;
    }

    public NetworkInterface withTagSet(Collection<Tag> tagSet) {
        this.setTagSet(tagSet);
        return this;
    }

    public List<NetworkInterfacePrivateIpAddress> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new SdkInternalList();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new SdkInternalList<NetworkInterfacePrivateIpAddress>(privateIpAddresses);
    }

    public NetworkInterface withPrivateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses(new SdkInternalList<NetworkInterfacePrivateIpAddress>(privateIpAddresses.length));
        }
        for (NetworkInterfacePrivateIpAddress ele : privateIpAddresses) {
            this.privateIpAddresses.add(ele);
        }
        return this;
    }

    public NetworkInterface withPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    public List<NetworkInterfaceIpv6Address> getIpv6Addresses() {
        if (this.ipv6Addresses == null) {
            this.ipv6Addresses = new SdkInternalList();
        }
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new SdkInternalList<NetworkInterfaceIpv6Address>(ipv6Addresses);
    }

    public NetworkInterface withIpv6Addresses(NetworkInterfaceIpv6Address ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses(new SdkInternalList<NetworkInterfaceIpv6Address>(ipv6Addresses.length));
        }
        for (NetworkInterfaceIpv6Address ele : ipv6Addresses) {
            this.ipv6Addresses.add(ele);
        }
        return this;
    }

    public NetworkInterface withIpv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public NetworkInterface withInterfaceType(String interfaceType) {
        this.setInterfaceType(interfaceType);
        return this;
    }

    @JsonIgnore
    public void setInterfaceType(NetworkInterfaceType interfaceType) {
        this.interfaceType = interfaceType.toString();
    }

    public NetworkInterface withInterfaceType(NetworkInterfaceType interfaceType) {
        this.setInterfaceType(interfaceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getRequesterId() != null) {
            sb.append("RequesterId: ").append(this.getRequesterId()).append(",");
        }
        if (this.getRequesterManaged() != null) {
            sb.append("RequesterManaged: ").append(this.getRequesterManaged()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getMacAddress() != null) {
            sb.append("MacAddress: ").append(this.getMacAddress()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getSourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.getSourceDestCheck()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getAttachment() != null) {
            sb.append("Attachment: ").append(this.getAttachment()).append(",");
        }
        if (this.getAssociation() != null) {
            sb.append("Association: ").append(this.getAssociation()).append(",");
        }
        if (this.getTagSet() != null) {
            sb.append("TagSet: ").append(this.getTagSet()).append(",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.getPrivateIpAddresses()).append(",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.getIpv6Addresses()).append(",");
        }
        if (this.getInterfaceType() != null) {
            sb.append("InterfaceType: ").append(this.getInterfaceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getRequesterId() == null ^ this.getRequesterId() == null) {
            return false;
        }
        if (other.getRequesterId() != null && !other.getRequesterId().equals(this.getRequesterId())) {
            return false;
        }
        if (other.getRequesterManaged() == null ^ this.getRequesterManaged() == null) {
            return false;
        }
        if (other.getRequesterManaged() != null && !other.getRequesterManaged().equals(this.getRequesterManaged())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        if (other.getMacAddress() != null && !other.getMacAddress().equals(this.getMacAddress())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getSourceDestCheck() == null ^ this.getSourceDestCheck() == null) {
            return false;
        }
        if (other.getSourceDestCheck() != null && !other.getSourceDestCheck().equals(this.getSourceDestCheck())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getAssociation() == null ^ this.getAssociation() == null) {
            return false;
        }
        if (other.getAssociation() != null && !other.getAssociation().equals(this.getAssociation())) {
            return false;
        }
        if (other.getTagSet() == null ^ this.getTagSet() == null) {
            return false;
        }
        if (other.getTagSet() != null && !other.getTagSet().equals(this.getTagSet())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getInterfaceType() == null ^ this.getInterfaceType() == null) {
            return false;
        }
        return other.getInterfaceType() == null || other.getInterfaceType().equals(this.getInterfaceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterId() == null ? 0 : this.getRequesterId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterManaged() == null ? 0 : this.getRequesterManaged().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDestCheck() == null ? 0 : this.getSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getAssociation() == null ? 0 : this.getAssociation().hashCode());
        hashCode = 31 * hashCode + (this.getTagSet() == null ? 0 : this.getTagSet().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getInterfaceType() == null ? 0 : this.getInterfaceType().hashCode());
        return hashCode;
    }

    public NetworkInterface clone() {
        try {
            return (NetworkInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

