/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.RuntimePlatform;

@SdkInternalApi
public class RuntimePlatformMarshaller {
    private static final MarshallingInfo<String> OPERATINGSYSTEMFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operatingSystemFamily").build();
    private static final MarshallingInfo<String> CPUARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuArchitecture").build();
    private static final RuntimePlatformMarshaller instance = new RuntimePlatformMarshaller();

    public static RuntimePlatformMarshaller getInstance() {
        return instance;
    }

    public void marshall(RuntimePlatform runtimePlatform, ProtocolMarshaller protocolMarshaller) {
        if (runtimePlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)runtimePlatform.getOperatingSystemFamily(), OPERATINGSYSTEMFAMILY_BINDING);
            protocolMarshaller.marshall((Object)runtimePlatform.getCpuArchitecture(), CPUARCHITECTURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

