/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.backupgateway.model.GatewayType;
import com.amazonaws.services.backupgateway.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String activationKey;
    private String gatewayDisplayName;
    private String gatewayType;
    private List<Tag> tags;

    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public CreateGatewayRequest withActivationKey(String activationKey) {
        this.setActivationKey(activationKey);
        return this;
    }

    public void setGatewayDisplayName(String gatewayDisplayName) {
        this.gatewayDisplayName = gatewayDisplayName;
    }

    public String getGatewayDisplayName() {
        return this.gatewayDisplayName;
    }

    public CreateGatewayRequest withGatewayDisplayName(String gatewayDisplayName) {
        this.setGatewayDisplayName(gatewayDisplayName);
        return this;
    }

    public void setGatewayType(String gatewayType) {
        this.gatewayType = gatewayType;
    }

    public String getGatewayType() {
        return this.gatewayType;
    }

    public CreateGatewayRequest withGatewayType(String gatewayType) {
        this.setGatewayType(gatewayType);
        return this;
    }

    public CreateGatewayRequest withGatewayType(GatewayType gatewayType) {
        this.gatewayType = gatewayType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateGatewayRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateGatewayRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivationKey() != null) {
            sb.append("ActivationKey: ").append(this.getActivationKey()).append(",");
        }
        if (this.getGatewayDisplayName() != null) {
            sb.append("GatewayDisplayName: ").append(this.getGatewayDisplayName()).append(",");
        }
        if (this.getGatewayType() != null) {
            sb.append("GatewayType: ").append(this.getGatewayType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest)obj;
        if (other.getActivationKey() == null ^ this.getActivationKey() == null) {
            return false;
        }
        if (other.getActivationKey() != null && !other.getActivationKey().equals(this.getActivationKey())) {
            return false;
        }
        if (other.getGatewayDisplayName() == null ^ this.getGatewayDisplayName() == null) {
            return false;
        }
        if (other.getGatewayDisplayName() != null && !other.getGatewayDisplayName().equals(this.getGatewayDisplayName())) {
            return false;
        }
        if (other.getGatewayType() == null ^ this.getGatewayType() == null) {
            return false;
        }
        if (other.getGatewayType() != null && !other.getGatewayType().equals(this.getGatewayType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivationKey() == null ? 0 : this.getActivationKey().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayDisplayName() == null ? 0 : this.getGatewayDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayType() == null ? 0 : this.getGatewayType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateGatewayRequest clone() {
        return (CreateGatewayRequest)super.clone();
    }
}

