/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.TrafficSourceIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AttachTrafficSourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private SdkInternalList<TrafficSourceIdentifier> trafficSources;

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public AttachTrafficSourcesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public List<TrafficSourceIdentifier> getTrafficSources() {
        if (this.trafficSources == null) {
            this.trafficSources = new SdkInternalList();
        }
        return this.trafficSources;
    }

    public void setTrafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
        if (trafficSources == null) {
            this.trafficSources = null;
            return;
        }
        this.trafficSources = new SdkInternalList(trafficSources);
    }

    public AttachTrafficSourcesRequest withTrafficSources(TrafficSourceIdentifier ... trafficSources) {
        if (this.trafficSources == null) {
            this.setTrafficSources((Collection<TrafficSourceIdentifier>)new SdkInternalList(trafficSources.length));
        }
        for (TrafficSourceIdentifier ele : trafficSources) {
            this.trafficSources.add((Object)ele);
        }
        return this;
    }

    public AttachTrafficSourcesRequest withTrafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
        this.setTrafficSources(trafficSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getTrafficSources() != null) {
            sb.append("TrafficSources: ").append(this.getTrafficSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachTrafficSourcesRequest)) {
            return false;
        }
        AttachTrafficSourcesRequest other = (AttachTrafficSourcesRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getTrafficSources() == null ^ this.getTrafficSources() == null) {
            return false;
        }
        return other.getTrafficSources() == null || other.getTrafficSources().equals(this.getTrafficSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficSources() == null ? 0 : this.getTrafficSources().hashCode());
        return hashCode;
    }

    public AttachTrafficSourcesRequest clone() {
        return (AttachTrafficSourcesRequest)super.clone();
    }
}

