/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.RefreshPreferences;
import com.amazonaws.services.autoscaling.model.StartInstanceRefreshRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartInstanceRefreshRequestMarshaller
implements Marshaller<Request<StartInstanceRefreshRequest>, StartInstanceRefreshRequest> {
    public Request<StartInstanceRefreshRequest> marshall(StartInstanceRefreshRequest startInstanceRefreshRequest) {
        RefreshPreferences preferences;
        if (startInstanceRefreshRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startInstanceRefreshRequest, "AmazonAutoScaling");
        request.addParameter("Action", "StartInstanceRefresh");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (startInstanceRefreshRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)startInstanceRefreshRequest.getAutoScalingGroupName()));
        }
        if (startInstanceRefreshRequest.getStrategy() != null) {
            request.addParameter("Strategy", StringUtils.fromString((String)startInstanceRefreshRequest.getStrategy()));
        }
        if ((preferences = startInstanceRefreshRequest.getPreferences()) != null) {
            if (preferences.getMinHealthyPercentage() != null) {
                request.addParameter("Preferences.MinHealthyPercentage", StringUtils.fromInteger((Integer)preferences.getMinHealthyPercentage()));
            }
            if (preferences.getInstanceWarmup() != null) {
                request.addParameter("Preferences.InstanceWarmup", StringUtils.fromInteger((Integer)preferences.getInstanceWarmup()));
            }
            if (!preferences.getCheckpointPercentages().isEmpty() || !((SdkInternalList)preferences.getCheckpointPercentages()).isAutoConstruct()) {
                SdkInternalList checkpointPercentagesList = (SdkInternalList)preferences.getCheckpointPercentages();
                int checkpointPercentagesListIndex = 1;
                for (Integer checkpointPercentagesListValue : checkpointPercentagesList) {
                    if (checkpointPercentagesListValue != null) {
                        request.addParameter("Preferences.CheckpointPercentages.member." + checkpointPercentagesListIndex, StringUtils.fromInteger((Integer)checkpointPercentagesListValue));
                    }
                    ++checkpointPercentagesListIndex;
                }
            }
            if (preferences.getCheckpointDelay() != null) {
                request.addParameter("Preferences.CheckpointDelay", StringUtils.fromInteger((Integer)preferences.getCheckpointDelay()));
            }
        }
        return request;
    }
}

