/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLaunchConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {
    public Request<DescribeLaunchConfigurationsRequest> marshall(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        if (describeLaunchConfigurationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLaunchConfigurationsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList launchConfigurationNamesList = (SdkInternalList)describeLaunchConfigurationsRequest.getLaunchConfigurationNames();
        if (!launchConfigurationNamesList.isEmpty() || !launchConfigurationNamesList.isAutoConstruct()) {
            int launchConfigurationNamesListIndex = 1;
            for (String launchConfigurationNamesListValue : launchConfigurationNamesList) {
                if (launchConfigurationNamesListValue != null) {
                    request.addParameter("LaunchConfigurationNames.member." + launchConfigurationNamesListIndex, StringUtils.fromString((String)launchConfigurationNamesListValue));
                }
                ++launchConfigurationNamesListIndex;
            }
        }
        if (describeLaunchConfigurationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeLaunchConfigurationsRequest.getNextToken()));
        }
        if (describeLaunchConfigurationsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeLaunchConfigurationsRequest.getMaxRecords()));
        }
        return request;
    }
}

