/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.auditmanager.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.auditmanager.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateSettingsRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateSettingsRequestMarshaller {

    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("snsTopic").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTASSESSMENTREPORTSDESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultAssessmentReportsDestination").build();
    private static final MarshallingInfo<List> DEFAULTPROCESSOWNERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultProcessOwners").build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("kmsKey").build();
    private static final MarshallingInfo<Boolean> EVIDENCEFINDERENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evidenceFinderEnabled").build();
    private static final MarshallingInfo<StructuredPojo> DEREGISTRATIONPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deregistrationPolicy").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTEXPORTDESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultExportDestination").build();

    private static final UpdateSettingsRequestMarshaller instance = new UpdateSettingsRequestMarshaller();

    public static UpdateSettingsRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateSettingsRequest updateSettingsRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateSettingsRequest.getSnsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getDefaultAssessmentReportsDestination(), DEFAULTASSESSMENTREPORTSDESTINATION_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getDefaultProcessOwners(), DEFAULTPROCESSOWNERS_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getKmsKey(), KMSKEY_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getEvidenceFinderEnabled(), EVIDENCEFINDERENABLED_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getDeregistrationPolicy(), DEREGISTRATIONPOLICY_BINDING);
            protocolMarshaller.marshall(updateSettingsRequest.getDefaultExportDestination(), DEFAULTEXPORTDESTINATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
