/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apptest.model.Resource;
import com.amazonaws.services.apptest.model.ServiceSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateTestConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String testConfigurationId;
    private String description;
    private List<Resource> resources;
    private Map<String, String> properties;
    private ServiceSettings serviceSettings;

    public void setTestConfigurationId(String testConfigurationId) {
        this.testConfigurationId = testConfigurationId;
    }

    public String getTestConfigurationId() {
        return this.testConfigurationId;
    }

    public UpdateTestConfigurationRequest withTestConfigurationId(String testConfigurationId) {
        this.setTestConfigurationId(testConfigurationId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateTestConfigurationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public UpdateTestConfigurationRequest withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public UpdateTestConfigurationRequest withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public UpdateTestConfigurationRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public UpdateTestConfigurationRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public UpdateTestConfigurationRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setServiceSettings(ServiceSettings serviceSettings) {
        this.serviceSettings = serviceSettings;
    }

    public ServiceSettings getServiceSettings() {
        return this.serviceSettings;
    }

    public UpdateTestConfigurationRequest withServiceSettings(ServiceSettings serviceSettings) {
        this.setServiceSettings(serviceSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTestConfigurationId() != null) {
            sb.append("TestConfigurationId: ").append(this.getTestConfigurationId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getServiceSettings() != null) {
            sb.append("ServiceSettings: ").append(this.getServiceSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestConfigurationRequest)) {
            return false;
        }
        UpdateTestConfigurationRequest other = (UpdateTestConfigurationRequest)obj;
        if (other.getTestConfigurationId() == null ^ this.getTestConfigurationId() == null) {
            return false;
        }
        if (other.getTestConfigurationId() != null && !other.getTestConfigurationId().equals(this.getTestConfigurationId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getServiceSettings() == null ^ this.getServiceSettings() == null) {
            return false;
        }
        return other.getServiceSettings() == null || other.getServiceSettings().equals(this.getServiceSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTestConfigurationId() == null ? 0 : this.getTestConfigurationId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getServiceSettings() == null ? 0 : this.getServiceSettings().hashCode());
        return hashCode;
    }

    public UpdateTestConfigurationRequest clone() {
        return (UpdateTestConfigurationRequest)super.clone();
    }
}

