/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apptest.model.CloudFormationAction;

@SdkInternalApi
public class CloudFormationActionMarshaller {
    private static final MarshallingInfo<String> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resource").build();
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionType").build();
    private static final CloudFormationActionMarshaller instance = new CloudFormationActionMarshaller();

    public static CloudFormationActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudFormationAction cloudFormationAction, ProtocolMarshaller protocolMarshaller) {
        if (cloudFormationAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudFormationAction.getResource(), RESOURCE_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationAction.getActionType(), ACTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

