/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync;

import javax.annotation.Generated;

import com.amazonaws.services.appsync.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAppSync}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppSync implements AWSAppSync {

    protected AbstractAWSAppSync() {
    }

    @Override
    public CreateApiKeyResult createApiKey(CreateApiKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGraphqlApiResult createGraphqlApi(CreateGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResolverResult createResolver(CreateResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTypeResult createType(CreateTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApiKeyResult deleteApiKey(DeleteApiKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGraphqlApiResult deleteGraphqlApi(DeleteGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResolverResult deleteResolver(DeleteResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTypeResult deleteType(DeleteTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGraphqlApiResult getGraphqlApi(GetGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntrospectionSchemaResult getIntrospectionSchema(GetIntrospectionSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverResult getResolver(GetResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaCreationStatusResult getSchemaCreationStatus(GetSchemaCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTypeResult getType(GetTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApiKeysResult listApiKeys(ListApiKeysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGraphqlApisResult listGraphqlApis(ListGraphqlApisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolversResult listResolvers(ListResolversRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTypesResult listTypes(ListTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSchemaCreationResult startSchemaCreation(StartSchemaCreationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGraphqlApiResult updateGraphqlApi(UpdateGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResolverResult updateResolver(UpdateResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTypeResult updateType(UpdateTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
