/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.ScriptDetails;

@SdkInternalApi
public class ScriptDetailsMarshaller {
    private static final MarshallingInfo<StructuredPojo> SCRIPTS3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScriptS3Location").build();
    private static final MarshallingInfo<String> EXECUTABLEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutablePath").build();
    private static final MarshallingInfo<String> EXECUTABLEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutableParameters").build();
    private static final MarshallingInfo<Integer> TIMEOUTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutInSeconds").build();
    private static final ScriptDetailsMarshaller instance = new ScriptDetailsMarshaller();

    public static ScriptDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScriptDetails scriptDetails, ProtocolMarshaller protocolMarshaller) {
        if (scriptDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scriptDetails.getScriptS3Location(), SCRIPTS3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)scriptDetails.getExecutablePath(), EXECUTABLEPATH_BINDING);
            protocolMarshaller.marshall((Object)scriptDetails.getExecutableParameters(), EXECUTABLEPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)scriptDetails.getTimeoutInSeconds(), TIMEOUTINSECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

