/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appstream.AmazonAppStream;
import com.amazonaws.services.appstream.AmazonAppStreamClientBuilder;
import com.amazonaws.services.appstream.model.AmazonAppStreamException;
import com.amazonaws.services.appstream.model.AssociateFleetRequest;
import com.amazonaws.services.appstream.model.AssociateFleetResult;
import com.amazonaws.services.appstream.model.ConcurrentModificationException;
import com.amazonaws.services.appstream.model.CreateFleetRequest;
import com.amazonaws.services.appstream.model.CreateFleetResult;
import com.amazonaws.services.appstream.model.CreateStackRequest;
import com.amazonaws.services.appstream.model.CreateStackResult;
import com.amazonaws.services.appstream.model.CreateStreamingURLRequest;
import com.amazonaws.services.appstream.model.CreateStreamingURLResult;
import com.amazonaws.services.appstream.model.DeleteFleetRequest;
import com.amazonaws.services.appstream.model.DeleteFleetResult;
import com.amazonaws.services.appstream.model.DeleteStackRequest;
import com.amazonaws.services.appstream.model.DeleteStackResult;
import com.amazonaws.services.appstream.model.DescribeFleetsRequest;
import com.amazonaws.services.appstream.model.DescribeFleetsResult;
import com.amazonaws.services.appstream.model.DescribeImagesRequest;
import com.amazonaws.services.appstream.model.DescribeImagesResult;
import com.amazonaws.services.appstream.model.DescribeSessionsRequest;
import com.amazonaws.services.appstream.model.DescribeSessionsResult;
import com.amazonaws.services.appstream.model.DescribeStacksRequest;
import com.amazonaws.services.appstream.model.DescribeStacksResult;
import com.amazonaws.services.appstream.model.DisassociateFleetRequest;
import com.amazonaws.services.appstream.model.DisassociateFleetResult;
import com.amazonaws.services.appstream.model.ExpireSessionRequest;
import com.amazonaws.services.appstream.model.ExpireSessionResult;
import com.amazonaws.services.appstream.model.IncompatibleImageException;
import com.amazonaws.services.appstream.model.InvalidParameterCombinationException;
import com.amazonaws.services.appstream.model.InvalidRoleException;
import com.amazonaws.services.appstream.model.LimitExceededException;
import com.amazonaws.services.appstream.model.ListAssociatedFleetsRequest;
import com.amazonaws.services.appstream.model.ListAssociatedFleetsResult;
import com.amazonaws.services.appstream.model.ListAssociatedStacksRequest;
import com.amazonaws.services.appstream.model.ListAssociatedStacksResult;
import com.amazonaws.services.appstream.model.OperationNotPermittedException;
import com.amazonaws.services.appstream.model.ResourceAlreadyExistsException;
import com.amazonaws.services.appstream.model.ResourceInUseException;
import com.amazonaws.services.appstream.model.ResourceNotAvailableException;
import com.amazonaws.services.appstream.model.ResourceNotFoundException;
import com.amazonaws.services.appstream.model.StartFleetRequest;
import com.amazonaws.services.appstream.model.StartFleetResult;
import com.amazonaws.services.appstream.model.StopFleetRequest;
import com.amazonaws.services.appstream.model.StopFleetResult;
import com.amazonaws.services.appstream.model.UpdateFleetRequest;
import com.amazonaws.services.appstream.model.UpdateFleetResult;
import com.amazonaws.services.appstream.model.UpdateStackRequest;
import com.amazonaws.services.appstream.model.UpdateStackResult;
import com.amazonaws.services.appstream.model.transform.AssociateFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.AssociateFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.CreateFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.CreateFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.CreateStackRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.CreateStackResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.CreateStreamingURLRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.CreateStreamingURLResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DeleteFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DeleteFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DeleteStackRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DeleteStackResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeFleetsRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeFleetsResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeImagesRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeImagesResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeSessionsRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeSessionsResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeStacksRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DescribeStacksResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.DisassociateFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.DisassociateFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.ExpireSessionRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.ExpireSessionResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.ListAssociatedFleetsRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.ListAssociatedFleetsResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.ListAssociatedStacksRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.ListAssociatedStacksResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.StartFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.StartFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.StopFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.StopFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.UpdateFleetRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.UpdateFleetResultJsonUnmarshaller;
import com.amazonaws.services.appstream.model.transform.UpdateStackRequestProtocolMarshaller;
import com.amazonaws.services.appstream.model.transform.UpdateStackResultJsonUnmarshaller;
import com.amazonaws.services.appstream.waiters.AmazonAppStreamWaiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonAppStreamClient
extends AmazonWebServiceClient
implements AmazonAppStream {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonAppStream.class);
    private static final String DEFAULT_SIGNING_NAME = "appstream";
    private volatile AmazonAppStreamWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncompatibleImageException").withModeledClass(IncompatibleImageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(InvalidRoleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(InvalidParameterCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotAvailableException").withModeledClass(ResourceNotAvailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonAppStreamException.class));

    @Deprecated
    public AmazonAppStreamClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonAppStreamClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonAppStreamClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonAppStreamClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonAppStreamClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonAppStreamClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonAppStreamClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonAppStreamClientBuilder builder() {
        return AmazonAppStreamClientBuilder.standard();
    }

    AmazonAppStreamClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("appstream2");
        this.setEndpoint("appstream2.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appstream/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appstream/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateFleetResult associateFleet(AssociateFleetRequest request) {
        request = (AssociateFleetRequest)this.beforeClientExecution(request);
        return this.executeAssociateFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateFleetResult executeAssociateFleet(AssociateFleetRequest associateFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateFleetRequestProtocolMarshaller(this.protocolFactory).marshall((AssociateFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateFleetResult associateFleetResult = (AssociateFleetResult)response.getAwsResponse();
            return associateFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFleetResult createFleet(CreateFleetRequest request) {
        request = (CreateFleetRequest)this.beforeClientExecution(request);
        return this.executeCreateFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFleetResult executeCreateFleet(CreateFleetRequest createFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFleetRequestProtocolMarshaller(this.protocolFactory).marshall((CreateFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFleetResult createFleetResult = (CreateFleetResult)response.getAwsResponse();
            return createFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStackResult createStack(CreateStackRequest request) {
        request = (CreateStackRequest)this.beforeClientExecution(request);
        return this.executeCreateStack(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStackResult executeCreateStack(CreateStackRequest createStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStackRequestProtocolMarshaller(this.protocolFactory).marshall((CreateStackRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStackResult createStackResult = (CreateStackResult)response.getAwsResponse();
            return createStackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStreamingURLResult createStreamingURL(CreateStreamingURLRequest request) {
        request = (CreateStreamingURLRequest)this.beforeClientExecution(request);
        return this.executeCreateStreamingURL(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStreamingURLResult executeCreateStreamingURL(CreateStreamingURLRequest createStreamingURLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStreamingURLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStreamingURLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStreamingURLRequestProtocolMarshaller(this.protocolFactory).marshall((CreateStreamingURLRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStreamingURLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamingURLResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStreamingURLResult createStreamingURLResult = (CreateStreamingURLResult)response.getAwsResponse();
            return createStreamingURLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFleetResult deleteFleet(DeleteFleetRequest request) {
        request = (DeleteFleetRequest)this.beforeClientExecution(request);
        return this.executeDeleteFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFleetResult executeDeleteFleet(DeleteFleetRequest deleteFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFleetRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFleetResult deleteFleetResult = (DeleteFleetResult)response.getAwsResponse();
            return deleteFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStackResult deleteStack(DeleteStackRequest request) {
        request = (DeleteStackRequest)this.beforeClientExecution(request);
        return this.executeDeleteStack(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStackResult executeDeleteStack(DeleteStackRequest deleteStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStackRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteStackRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStackResult deleteStackResult = (DeleteStackResult)response.getAwsResponse();
            return deleteStackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFleetsResult describeFleets(DescribeFleetsRequest request) {
        request = (DescribeFleetsRequest)this.beforeClientExecution(request);
        return this.executeDescribeFleets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFleetsResult executeDescribeFleets(DescribeFleetsRequest describeFleetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFleetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFleetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFleetsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeFleetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFleetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFleetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFleetsResult describeFleetsResult = (DescribeFleetsResult)response.getAwsResponse();
            return describeFleetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeImagesResult describeImages(DescribeImagesRequest request) {
        request = (DescribeImagesRequest)this.beforeClientExecution(request);
        return this.executeDescribeImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeImagesResult executeDescribeImages(DescribeImagesRequest describeImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeImagesRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeImagesResult describeImagesResult = (DescribeImagesResult)response.getAwsResponse();
            return describeImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSessionsResult describeSessions(DescribeSessionsRequest request) {
        request = (DescribeSessionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeSessions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSessionsResult executeDescribeSessions(DescribeSessionsRequest describeSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSessionsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSessionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSessionsResult describeSessionsResult = (DescribeSessionsResult)response.getAwsResponse();
            return describeSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeStacksResult describeStacks(DescribeStacksRequest request) {
        request = (DescribeStacksRequest)this.beforeClientExecution(request);
        return this.executeDescribeStacks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeStacksResult executeDescribeStacks(DescribeStacksRequest describeStacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStacksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStacksRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeStacksRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeStacksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStacksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStacksResult describeStacksResult = (DescribeStacksResult)response.getAwsResponse();
            return describeStacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateFleetResult disassociateFleet(DisassociateFleetRequest request) {
        request = (DisassociateFleetRequest)this.beforeClientExecution(request);
        return this.executeDisassociateFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateFleetResult executeDisassociateFleet(DisassociateFleetRequest disassociateFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateFleetRequestProtocolMarshaller(this.protocolFactory).marshall((DisassociateFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateFleetResult disassociateFleetResult = (DisassociateFleetResult)response.getAwsResponse();
            return disassociateFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExpireSessionResult expireSession(ExpireSessionRequest request) {
        request = (ExpireSessionRequest)this.beforeClientExecution(request);
        return this.executeExpireSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExpireSessionResult executeExpireSession(ExpireSessionRequest expireSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(expireSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExpireSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExpireSessionRequestProtocolMarshaller(this.protocolFactory).marshall((ExpireSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)expireSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExpireSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExpireSessionResult expireSessionResult = (ExpireSessionResult)response.getAwsResponse();
            return expireSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssociatedFleetsResult listAssociatedFleets(ListAssociatedFleetsRequest request) {
        request = (ListAssociatedFleetsRequest)this.beforeClientExecution(request);
        return this.executeListAssociatedFleets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssociatedFleetsResult executeListAssociatedFleets(ListAssociatedFleetsRequest listAssociatedFleetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociatedFleetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociatedFleetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociatedFleetsRequestProtocolMarshaller(this.protocolFactory).marshall((ListAssociatedFleetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssociatedFleetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssociatedFleetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociatedFleetsResult listAssociatedFleetsResult = (ListAssociatedFleetsResult)response.getAwsResponse();
            return listAssociatedFleetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssociatedStacksResult listAssociatedStacks(ListAssociatedStacksRequest request) {
        request = (ListAssociatedStacksRequest)this.beforeClientExecution(request);
        return this.executeListAssociatedStacks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssociatedStacksResult executeListAssociatedStacks(ListAssociatedStacksRequest listAssociatedStacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociatedStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociatedStacksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociatedStacksRequestProtocolMarshaller(this.protocolFactory).marshall((ListAssociatedStacksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssociatedStacksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssociatedStacksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociatedStacksResult listAssociatedStacksResult = (ListAssociatedStacksResult)response.getAwsResponse();
            return listAssociatedStacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFleetResult startFleet(StartFleetRequest request) {
        request = (StartFleetRequest)this.beforeClientExecution(request);
        return this.executeStartFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFleetResult executeStartFleet(StartFleetRequest startFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFleetRequestProtocolMarshaller(this.protocolFactory).marshall((StartFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFleetResult startFleetResult = (StartFleetResult)response.getAwsResponse();
            return startFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopFleetResult stopFleet(StopFleetRequest request) {
        request = (StopFleetRequest)this.beforeClientExecution(request);
        return this.executeStopFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopFleetResult executeStopFleet(StopFleetRequest stopFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopFleetRequestProtocolMarshaller(this.protocolFactory).marshall((StopFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopFleetResult stopFleetResult = (StopFleetResult)response.getAwsResponse();
            return stopFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFleetResult updateFleet(UpdateFleetRequest request) {
        request = (UpdateFleetRequest)this.beforeClientExecution(request);
        return this.executeUpdateFleet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFleetResult executeUpdateFleet(UpdateFleetRequest updateFleetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFleetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFleetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFleetRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateFleetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFleetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFleetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFleetResult updateFleetResult = (UpdateFleetResult)response.getAwsResponse();
            return updateFleetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateStackResult updateStack(UpdateStackRequest request) {
        request = (UpdateStackRequest)this.beforeClientExecution(request);
        return this.executeUpdateStack(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateStackResult executeUpdateStack(UpdateStackRequest updateStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateStackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateStackRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateStackRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateStackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateStackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateStackResult updateStackResult = (UpdateStackResult)response.getAwsResponse();
            return updateStackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonAppStreamWaiters waiters() {
        if (this.waiters == null) {
            AmazonAppStreamClient amazonAppStreamClient = this;
            synchronized (amazonAppStreamClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonAppStreamWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

