/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apprunner.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeObservabilityConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeObservabilityConfigurationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * A full description of the App Runner observability configuration that you specified in this request.
     * </p>
     */
    private ObservabilityConfiguration observabilityConfiguration;

    /**
     * <p>
     * A full description of the App Runner observability configuration that you specified in this request.
     * </p>
     * 
     * @param observabilityConfiguration
     *        A full description of the App Runner observability configuration that you specified in this request.
     */

    public void setObservabilityConfiguration(ObservabilityConfiguration observabilityConfiguration) {
        this.observabilityConfiguration = observabilityConfiguration;
    }

    /**
     * <p>
     * A full description of the App Runner observability configuration that you specified in this request.
     * </p>
     * 
     * @return A full description of the App Runner observability configuration that you specified in this request.
     */

    public ObservabilityConfiguration getObservabilityConfiguration() {
        return this.observabilityConfiguration;
    }

    /**
     * <p>
     * A full description of the App Runner observability configuration that you specified in this request.
     * </p>
     * 
     * @param observabilityConfiguration
     *        A full description of the App Runner observability configuration that you specified in this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeObservabilityConfigurationResult withObservabilityConfiguration(ObservabilityConfiguration observabilityConfiguration) {
        setObservabilityConfiguration(observabilityConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getObservabilityConfiguration() != null)
            sb.append("ObservabilityConfiguration: ").append(getObservabilityConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeObservabilityConfigurationResult == false)
            return false;
        DescribeObservabilityConfigurationResult other = (DescribeObservabilityConfigurationResult) obj;
        if (other.getObservabilityConfiguration() == null ^ this.getObservabilityConfiguration() == null)
            return false;
        if (other.getObservabilityConfiguration() != null && other.getObservabilityConfiguration().equals(this.getObservabilityConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getObservabilityConfiguration() == null) ? 0 : getObservabilityConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public DescribeObservabilityConfigurationResult clone() {
        try {
            return (DescribeObservabilityConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
