/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.services.appmesh.model.OutlierDetection;
import com.amazonaws.services.appmesh.model.transform.DurationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class OutlierDetectionJsonUnmarshaller
implements Unmarshaller<OutlierDetection, JsonUnmarshallerContext> {
    private static OutlierDetectionJsonUnmarshaller instance;

    public OutlierDetection unmarshall(JsonUnmarshallerContext context) throws Exception {
        OutlierDetection outlierDetection = new OutlierDetection();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("baseEjectionDuration", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    outlierDetection.setBaseEjectionDuration(DurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("interval", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    outlierDetection.setInterval(DurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("maxEjectionPercent", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    outlierDetection.setMaxEjectionPercent((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxServerErrors", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    outlierDetection.setMaxServerErrors((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return outlierDetection;
    }

    public static OutlierDetectionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OutlierDetectionJsonUnmarshaller();
        }
        return instance;
    }
}

