/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appmesh.model.MeshSpec;
import com.amazonaws.services.appmesh.model.TagRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMeshRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String meshName;
    private MeshSpec spec;
    private List<TagRef> tags;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateMeshRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setMeshName(String meshName) {
        this.meshName = meshName;
    }

    public String getMeshName() {
        return this.meshName;
    }

    public CreateMeshRequest withMeshName(String meshName) {
        this.setMeshName(meshName);
        return this;
    }

    public void setSpec(MeshSpec spec) {
        this.spec = spec;
    }

    public MeshSpec getSpec() {
        return this.spec;
    }

    public CreateMeshRequest withSpec(MeshSpec spec) {
        this.setSpec(spec);
        return this;
    }

    public List<TagRef> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagRef> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagRef>(tags);
    }

    public CreateMeshRequest withTags(TagRef ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagRef>(tags.length));
        }
        for (TagRef ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateMeshRequest withTags(Collection<TagRef> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getMeshName() != null) {
            sb.append("MeshName: ").append(this.getMeshName()).append(",");
        }
        if (this.getSpec() != null) {
            sb.append("Spec: ").append(this.getSpec()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeshRequest)) {
            return false;
        }
        CreateMeshRequest other = (CreateMeshRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getMeshName() == null ^ this.getMeshName() == null) {
            return false;
        }
        if (other.getMeshName() != null && !other.getMeshName().equals(this.getMeshName())) {
            return false;
        }
        if (other.getSpec() == null ^ this.getSpec() == null) {
            return false;
        }
        if (other.getSpec() != null && !other.getSpec().equals(this.getSpec())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getMeshName() == null ? 0 : this.getMeshName().hashCode());
        hashCode = 31 * hashCode + (this.getSpec() == null ? 0 : this.getSpec().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateMeshRequest clone() {
        return (CreateMeshRequest)super.clone();
    }
}

