/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.applicationsignals.AmazonApplicationSignals;
import com.amazonaws.services.applicationsignals.AmazonApplicationSignalsClientBuilder;
import com.amazonaws.services.applicationsignals.model.AmazonApplicationSignalsException;
import com.amazonaws.services.applicationsignals.model.BatchGetServiceLevelObjectiveBudgetReportRequest;
import com.amazonaws.services.applicationsignals.model.BatchGetServiceLevelObjectiveBudgetReportResult;
import com.amazonaws.services.applicationsignals.model.CreateServiceLevelObjectiveRequest;
import com.amazonaws.services.applicationsignals.model.CreateServiceLevelObjectiveResult;
import com.amazonaws.services.applicationsignals.model.DeleteServiceLevelObjectiveRequest;
import com.amazonaws.services.applicationsignals.model.DeleteServiceLevelObjectiveResult;
import com.amazonaws.services.applicationsignals.model.GetServiceLevelObjectiveRequest;
import com.amazonaws.services.applicationsignals.model.GetServiceLevelObjectiveResult;
import com.amazonaws.services.applicationsignals.model.GetServiceRequest;
import com.amazonaws.services.applicationsignals.model.GetServiceResult;
import com.amazonaws.services.applicationsignals.model.ListServiceDependenciesRequest;
import com.amazonaws.services.applicationsignals.model.ListServiceDependenciesResult;
import com.amazonaws.services.applicationsignals.model.ListServiceDependentsRequest;
import com.amazonaws.services.applicationsignals.model.ListServiceDependentsResult;
import com.amazonaws.services.applicationsignals.model.ListServiceLevelObjectivesRequest;
import com.amazonaws.services.applicationsignals.model.ListServiceLevelObjectivesResult;
import com.amazonaws.services.applicationsignals.model.ListServiceOperationsRequest;
import com.amazonaws.services.applicationsignals.model.ListServiceOperationsResult;
import com.amazonaws.services.applicationsignals.model.ListServicesRequest;
import com.amazonaws.services.applicationsignals.model.ListServicesResult;
import com.amazonaws.services.applicationsignals.model.ListTagsForResourceRequest;
import com.amazonaws.services.applicationsignals.model.ListTagsForResourceResult;
import com.amazonaws.services.applicationsignals.model.StartDiscoveryRequest;
import com.amazonaws.services.applicationsignals.model.StartDiscoveryResult;
import com.amazonaws.services.applicationsignals.model.TagResourceRequest;
import com.amazonaws.services.applicationsignals.model.TagResourceResult;
import com.amazonaws.services.applicationsignals.model.UntagResourceRequest;
import com.amazonaws.services.applicationsignals.model.UntagResourceResult;
import com.amazonaws.services.applicationsignals.model.UpdateServiceLevelObjectiveRequest;
import com.amazonaws.services.applicationsignals.model.UpdateServiceLevelObjectiveResult;
import com.amazonaws.services.applicationsignals.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.BatchGetServiceLevelObjectiveBudgetReportRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.BatchGetServiceLevelObjectiveBudgetReportResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.CreateServiceLevelObjectiveRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.CreateServiceLevelObjectiveResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.DeleteServiceLevelObjectiveRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.DeleteServiceLevelObjectiveResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.GetServiceLevelObjectiveRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.GetServiceLevelObjectiveResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.GetServiceRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.GetServiceResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceDependenciesRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceDependenciesResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceDependentsRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceDependentsResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceLevelObjectivesRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceLevelObjectivesResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceOperationsRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServiceOperationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServicesRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.StartDiscoveryRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.StartDiscoveryResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.UpdateServiceLevelObjectiveRequestProtocolMarshaller;
import com.amazonaws.services.applicationsignals.model.transform.UpdateServiceLevelObjectiveResultJsonUnmarshaller;
import com.amazonaws.services.applicationsignals.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonApplicationSignalsClient
extends AmazonWebServiceClient
implements AmazonApplicationSignals {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonApplicationSignals.class);
    private static final String DEFAULT_SIGNING_NAME = "application-signals";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonApplicationSignalsException.class));

    public static AmazonApplicationSignalsClientBuilder builder() {
        return AmazonApplicationSignalsClientBuilder.standard();
    }

    AmazonApplicationSignalsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonApplicationSignalsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("application-signals.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/applicationsignals/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/applicationsignals/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetServiceLevelObjectiveBudgetReportResult batchGetServiceLevelObjectiveBudgetReport(BatchGetServiceLevelObjectiveBudgetReportRequest request) {
        request = (BatchGetServiceLevelObjectiveBudgetReportRequest)this.beforeClientExecution(request);
        return this.executeBatchGetServiceLevelObjectiveBudgetReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetServiceLevelObjectiveBudgetReportResult executeBatchGetServiceLevelObjectiveBudgetReport(BatchGetServiceLevelObjectiveBudgetReportRequest batchGetServiceLevelObjectiveBudgetReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetServiceLevelObjectiveBudgetReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetServiceLevelObjectiveBudgetReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetServiceLevelObjectiveBudgetReportRequestProtocolMarshaller(protocolFactory).marshall((BatchGetServiceLevelObjectiveBudgetReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetServiceLevelObjectiveBudgetReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetServiceLevelObjectiveBudgetReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetServiceLevelObjectiveBudgetReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetServiceLevelObjectiveBudgetReportResult batchGetServiceLevelObjectiveBudgetReportResult = (BatchGetServiceLevelObjectiveBudgetReportResult)response.getAwsResponse();
            return batchGetServiceLevelObjectiveBudgetReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateServiceLevelObjectiveResult createServiceLevelObjective(CreateServiceLevelObjectiveRequest request) {
        request = (CreateServiceLevelObjectiveRequest)this.beforeClientExecution(request);
        return this.executeCreateServiceLevelObjective(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateServiceLevelObjectiveResult executeCreateServiceLevelObjective(CreateServiceLevelObjectiveRequest createServiceLevelObjectiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceLevelObjectiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceLevelObjectiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceLevelObjectiveRequestProtocolMarshaller(protocolFactory).marshall((CreateServiceLevelObjectiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)createServiceLevelObjectiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateServiceLevelObjective");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServiceLevelObjectiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServiceLevelObjectiveResult createServiceLevelObjectiveResult = (CreateServiceLevelObjectiveResult)response.getAwsResponse();
            return createServiceLevelObjectiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServiceLevelObjectiveResult deleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest request) {
        request = (DeleteServiceLevelObjectiveRequest)this.beforeClientExecution(request);
        return this.executeDeleteServiceLevelObjective(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServiceLevelObjectiveResult executeDeleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest deleteServiceLevelObjectiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceLevelObjectiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceLevelObjectiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceLevelObjectiveRequestProtocolMarshaller(protocolFactory).marshall((DeleteServiceLevelObjectiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteServiceLevelObjectiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteServiceLevelObjective");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServiceLevelObjectiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServiceLevelObjectiveResult deleteServiceLevelObjectiveResult = (DeleteServiceLevelObjectiveResult)response.getAwsResponse();
            return deleteServiceLevelObjectiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) {
        request = (GetServiceRequest)this.beforeClientExecution(request);
        return this.executeGetService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceResult executeGetService(GetServiceRequest getServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceRequestProtocolMarshaller(protocolFactory).marshall((GetServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceResult getServiceResult = (GetServiceResult)response.getAwsResponse();
            return getServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceLevelObjectiveResult getServiceLevelObjective(GetServiceLevelObjectiveRequest request) {
        request = (GetServiceLevelObjectiveRequest)this.beforeClientExecution(request);
        return this.executeGetServiceLevelObjective(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceLevelObjectiveResult executeGetServiceLevelObjective(GetServiceLevelObjectiveRequest getServiceLevelObjectiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceLevelObjectiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceLevelObjectiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceLevelObjectiveRequestProtocolMarshaller(protocolFactory).marshall((GetServiceLevelObjectiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceLevelObjectiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetServiceLevelObjective");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceLevelObjectiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceLevelObjectiveResult getServiceLevelObjectiveResult = (GetServiceLevelObjectiveResult)response.getAwsResponse();
            return getServiceLevelObjectiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServiceDependenciesResult listServiceDependencies(ListServiceDependenciesRequest request) {
        request = (ListServiceDependenciesRequest)this.beforeClientExecution(request);
        return this.executeListServiceDependencies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServiceDependenciesResult executeListServiceDependencies(ListServiceDependenciesRequest listServiceDependenciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServiceDependenciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServiceDependenciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServiceDependenciesRequestProtocolMarshaller(protocolFactory).marshall((ListServiceDependenciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServiceDependenciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServiceDependencies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServiceDependenciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServiceDependenciesResult listServiceDependenciesResult = (ListServiceDependenciesResult)response.getAwsResponse();
            return listServiceDependenciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServiceDependentsResult listServiceDependents(ListServiceDependentsRequest request) {
        request = (ListServiceDependentsRequest)this.beforeClientExecution(request);
        return this.executeListServiceDependents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServiceDependentsResult executeListServiceDependents(ListServiceDependentsRequest listServiceDependentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServiceDependentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServiceDependentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServiceDependentsRequestProtocolMarshaller(protocolFactory).marshall((ListServiceDependentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServiceDependentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServiceDependents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServiceDependentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServiceDependentsResult listServiceDependentsResult = (ListServiceDependentsResult)response.getAwsResponse();
            return listServiceDependentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServiceLevelObjectivesResult listServiceLevelObjectives(ListServiceLevelObjectivesRequest request) {
        request = (ListServiceLevelObjectivesRequest)this.beforeClientExecution(request);
        return this.executeListServiceLevelObjectives(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServiceLevelObjectivesResult executeListServiceLevelObjectives(ListServiceLevelObjectivesRequest listServiceLevelObjectivesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServiceLevelObjectivesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServiceLevelObjectivesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServiceLevelObjectivesRequestProtocolMarshaller(protocolFactory).marshall((ListServiceLevelObjectivesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServiceLevelObjectivesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServiceLevelObjectives");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServiceLevelObjectivesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServiceLevelObjectivesResult listServiceLevelObjectivesResult = (ListServiceLevelObjectivesResult)response.getAwsResponse();
            return listServiceLevelObjectivesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServiceOperationsResult listServiceOperations(ListServiceOperationsRequest request) {
        request = (ListServiceOperationsRequest)this.beforeClientExecution(request);
        return this.executeListServiceOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServiceOperationsResult executeListServiceOperations(ListServiceOperationsRequest listServiceOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServiceOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServiceOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServiceOperationsRequestProtocolMarshaller(protocolFactory).marshall((ListServiceOperationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServiceOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServiceOperations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServiceOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServiceOperationsResult listServiceOperationsResult = (ListServiceOperationsResult)response.getAwsResponse();
            return listServiceOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        request = (ListServicesRequest)this.beforeClientExecution(request);
        return this.executeListServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServicesResult executeListServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestProtocolMarshaller(protocolFactory).marshall((ListServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDiscoveryResult startDiscovery(StartDiscoveryRequest request) {
        request = (StartDiscoveryRequest)this.beforeClientExecution(request);
        return this.executeStartDiscovery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDiscoveryResult executeStartDiscovery(StartDiscoveryRequest startDiscoveryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDiscoveryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDiscoveryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDiscoveryRequestProtocolMarshaller(protocolFactory).marshall((StartDiscoveryRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDiscoveryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDiscovery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDiscoveryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDiscoveryResult startDiscoveryResult = (StartDiscoveryResult)response.getAwsResponse();
            return startDiscoveryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceLevelObjectiveResult updateServiceLevelObjective(UpdateServiceLevelObjectiveRequest request) {
        request = (UpdateServiceLevelObjectiveRequest)this.beforeClientExecution(request);
        return this.executeUpdateServiceLevelObjective(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceLevelObjectiveResult executeUpdateServiceLevelObjective(UpdateServiceLevelObjectiveRequest updateServiceLevelObjectiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceLevelObjectiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceLevelObjectiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceLevelObjectiveRequestProtocolMarshaller(protocolFactory).marshall((UpdateServiceLevelObjectiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceLevelObjectiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Signals");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateServiceLevelObjective");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceLevelObjectiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceLevelObjectiveResult updateServiceLevelObjectiveResult = (UpdateServiceLevelObjectiveResult)response.getAwsResponse();
            return updateServiceLevelObjectiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

