/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.applicationinsights.AmazonApplicationInsights;
import com.amazonaws.services.applicationinsights.AmazonApplicationInsightsClientBuilder;
import com.amazonaws.services.applicationinsights.model.AmazonApplicationInsightsException;
import com.amazonaws.services.applicationinsights.model.BadRequestException;
import com.amazonaws.services.applicationinsights.model.CreateApplicationRequest;
import com.amazonaws.services.applicationinsights.model.CreateApplicationResult;
import com.amazonaws.services.applicationinsights.model.CreateComponentRequest;
import com.amazonaws.services.applicationinsights.model.CreateComponentResult;
import com.amazonaws.services.applicationinsights.model.DeleteApplicationRequest;
import com.amazonaws.services.applicationinsights.model.DeleteApplicationResult;
import com.amazonaws.services.applicationinsights.model.DeleteComponentRequest;
import com.amazonaws.services.applicationinsights.model.DeleteComponentResult;
import com.amazonaws.services.applicationinsights.model.DescribeApplicationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeApplicationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentResult;
import com.amazonaws.services.applicationinsights.model.DescribeObservationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeObservationResult;
import com.amazonaws.services.applicationinsights.model.DescribeProblemObservationsRequest;
import com.amazonaws.services.applicationinsights.model.DescribeProblemObservationsResult;
import com.amazonaws.services.applicationinsights.model.DescribeProblemRequest;
import com.amazonaws.services.applicationinsights.model.DescribeProblemResult;
import com.amazonaws.services.applicationinsights.model.InternalServerException;
import com.amazonaws.services.applicationinsights.model.ListApplicationsRequest;
import com.amazonaws.services.applicationinsights.model.ListApplicationsResult;
import com.amazonaws.services.applicationinsights.model.ListComponentsRequest;
import com.amazonaws.services.applicationinsights.model.ListComponentsResult;
import com.amazonaws.services.applicationinsights.model.ListProblemsRequest;
import com.amazonaws.services.applicationinsights.model.ListProblemsResult;
import com.amazonaws.services.applicationinsights.model.ResourceInUseException;
import com.amazonaws.services.applicationinsights.model.ResourceNotFoundException;
import com.amazonaws.services.applicationinsights.model.UpdateComponentConfigurationRequest;
import com.amazonaws.services.applicationinsights.model.UpdateComponentConfigurationResult;
import com.amazonaws.services.applicationinsights.model.UpdateComponentRequest;
import com.amazonaws.services.applicationinsights.model.UpdateComponentResult;
import com.amazonaws.services.applicationinsights.model.ValidationException;
import com.amazonaws.services.applicationinsights.model.transform.CreateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.CreateComponentRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.CreateComponentResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DeleteApplicationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DeleteComponentRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DeleteComponentResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeApplicationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeApplicationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentConfigurationRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentConfigurationRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeComponentResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeObservationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeObservationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeProblemObservationsRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeProblemObservationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeProblemRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.DescribeProblemResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListApplicationsRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListComponentsRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListComponentsResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListProblemsRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.ListProblemsResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.UpdateComponentConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.UpdateComponentConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.applicationinsights.model.transform.UpdateComponentRequestProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.transform.UpdateComponentResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonApplicationInsightsClient
extends AmazonWebServiceClient
implements AmazonApplicationInsights {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonApplicationInsights.class);
    private static final String DEFAULT_SIGNING_NAME = "applicationinsights";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).withBaseServiceExceptionClass(AmazonApplicationInsightsException.class));

    public static AmazonApplicationInsightsClientBuilder builder() {
        return AmazonApplicationInsightsClientBuilder.standard();
    }

    AmazonApplicationInsightsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonApplicationInsightsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("applicationinsights.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/applicationinsights/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/applicationinsights/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        request = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executeCreateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApplicationResult executeCreateApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestProtocolMarshaller(protocolFactory).marshall((CreateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateComponentResult createComponent(CreateComponentRequest request) {
        request = (CreateComponentRequest)this.beforeClientExecution(request);
        return this.executeCreateComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateComponentResult executeCreateComponent(CreateComponentRequest createComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateComponentRequestProtocolMarshaller(protocolFactory).marshall((CreateComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)createComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateComponentResult createComponentResult = (CreateComponentResult)response.getAwsResponse();
            return createComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        request = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationResult executeDeleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteComponentResult deleteComponent(DeleteComponentRequest request) {
        request = (DeleteComponentRequest)this.beforeClientExecution(request);
        return this.executeDeleteComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteComponentResult executeDeleteComponent(DeleteComponentRequest deleteComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteComponentRequestProtocolMarshaller(protocolFactory).marshall((DeleteComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteComponentResult deleteComponentResult = (DeleteComponentResult)response.getAwsResponse();
            return deleteComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeApplicationResult describeApplication(DescribeApplicationRequest request) {
        request = (DescribeApplicationRequest)this.beforeClientExecution(request);
        return this.executeDescribeApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeApplicationResult executeDescribeApplication(DescribeApplicationRequest describeApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationRequestProtocolMarshaller(protocolFactory).marshall((DescribeApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeApplicationResult describeApplicationResult = (DescribeApplicationResult)response.getAwsResponse();
            return describeApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComponentResult describeComponent(DescribeComponentRequest request) {
        request = (DescribeComponentRequest)this.beforeClientExecution(request);
        return this.executeDescribeComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeComponentResult executeDescribeComponent(DescribeComponentRequest describeComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComponentRequestProtocolMarshaller(protocolFactory).marshall((DescribeComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComponentResult describeComponentResult = (DescribeComponentResult)response.getAwsResponse();
            return describeComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComponentConfigurationResult describeComponentConfiguration(DescribeComponentConfigurationRequest request) {
        request = (DescribeComponentConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribeComponentConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeComponentConfigurationResult executeDescribeComponentConfiguration(DescribeComponentConfigurationRequest describeComponentConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComponentConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComponentConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComponentConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribeComponentConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComponentConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeComponentConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComponentConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComponentConfigurationResult describeComponentConfigurationResult = (DescribeComponentConfigurationResult)response.getAwsResponse();
            return describeComponentConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComponentConfigurationRecommendationResult describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest request) {
        request = (DescribeComponentConfigurationRecommendationRequest)this.beforeClientExecution(request);
        return this.executeDescribeComponentConfigurationRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeComponentConfigurationRecommendationResult executeDescribeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest describeComponentConfigurationRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComponentConfigurationRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComponentConfigurationRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComponentConfigurationRecommendationRequestProtocolMarshaller(protocolFactory).marshall((DescribeComponentConfigurationRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComponentConfigurationRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeComponentConfigurationRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComponentConfigurationRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComponentConfigurationRecommendationResult describeComponentConfigurationRecommendationResult = (DescribeComponentConfigurationRecommendationResult)response.getAwsResponse();
            return describeComponentConfigurationRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeObservationResult describeObservation(DescribeObservationRequest request) {
        request = (DescribeObservationRequest)this.beforeClientExecution(request);
        return this.executeDescribeObservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeObservationResult executeDescribeObservation(DescribeObservationRequest describeObservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeObservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeObservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeObservationRequestProtocolMarshaller(protocolFactory).marshall((DescribeObservationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeObservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeObservation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeObservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeObservationResult describeObservationResult = (DescribeObservationResult)response.getAwsResponse();
            return describeObservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProblemResult describeProblem(DescribeProblemRequest request) {
        request = (DescribeProblemRequest)this.beforeClientExecution(request);
        return this.executeDescribeProblem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProblemResult executeDescribeProblem(DescribeProblemRequest describeProblemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProblemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProblemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProblemRequestProtocolMarshaller(protocolFactory).marshall((DescribeProblemRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProblemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProblem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProblemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProblemResult describeProblemResult = (DescribeProblemResult)response.getAwsResponse();
            return describeProblemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProblemObservationsResult describeProblemObservations(DescribeProblemObservationsRequest request) {
        request = (DescribeProblemObservationsRequest)this.beforeClientExecution(request);
        return this.executeDescribeProblemObservations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProblemObservationsResult executeDescribeProblemObservations(DescribeProblemObservationsRequest describeProblemObservationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProblemObservationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProblemObservationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProblemObservationsRequestProtocolMarshaller(protocolFactory).marshall((DescribeProblemObservationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProblemObservationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProblemObservations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProblemObservationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProblemObservationsResult describeProblemObservationsResult = (DescribeProblemObservationsResult)response.getAwsResponse();
            return describeProblemObservationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        request = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executeListApplications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationsResult executeListApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        request = (ListComponentsRequest)this.beforeClientExecution(request);
        return this.executeListComponents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComponentsResult executeListComponents(ListComponentsRequest listComponentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComponentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComponentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComponentsRequestProtocolMarshaller(protocolFactory).marshall((ListComponentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComponentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComponents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComponentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListComponentsResult listComponentsResult = (ListComponentsResult)response.getAwsResponse();
            return listComponentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProblemsResult listProblems(ListProblemsRequest request) {
        request = (ListProblemsRequest)this.beforeClientExecution(request);
        return this.executeListProblems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProblemsResult executeListProblems(ListProblemsRequest listProblemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProblemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProblemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProblemsRequestProtocolMarshaller(protocolFactory).marshall((ListProblemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProblemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProblems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProblemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProblemsResult listProblemsResult = (ListProblemsResult)response.getAwsResponse();
            return listProblemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateComponentResult updateComponent(UpdateComponentRequest request) {
        request = (UpdateComponentRequest)this.beforeClientExecution(request);
        return this.executeUpdateComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateComponentResult executeUpdateComponent(UpdateComponentRequest updateComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateComponentRequestProtocolMarshaller(protocolFactory).marshall((UpdateComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateComponentResult updateComponentResult = (UpdateComponentResult)response.getAwsResponse();
            return updateComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateComponentConfigurationResult updateComponentConfiguration(UpdateComponentConfigurationRequest request) {
        request = (UpdateComponentConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateComponentConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateComponentConfigurationResult executeUpdateComponentConfiguration(UpdateComponentConfigurationRequest updateComponentConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateComponentConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateComponentConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateComponentConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateComponentConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateComponentConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Application Insights");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateComponentConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateComponentConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateComponentConfigurationResult updateComponentConfigurationResult = (UpdateComponentConfigurationResult)response.getAwsResponse();
            return updateComponentConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

