/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationinsights.model.OsType;
import com.amazonaws.services.applicationinsights.model.Tier;
import com.amazonaws.services.applicationinsights.model.transform.ApplicationComponentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ApplicationComponent
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentName;
    private String componentRemarks;
    private String resourceType;
    private String osType;
    private String tier;
    private Boolean monitor;
    private Map<String, Map<String, String>> detectedWorkload;

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ApplicationComponent withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public void setComponentRemarks(String componentRemarks) {
        this.componentRemarks = componentRemarks;
    }

    public String getComponentRemarks() {
        return this.componentRemarks;
    }

    public ApplicationComponent withComponentRemarks(String componentRemarks) {
        this.setComponentRemarks(componentRemarks);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ApplicationComponent withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getOsType() {
        return this.osType;
    }

    public ApplicationComponent withOsType(String osType) {
        this.setOsType(osType);
        return this;
    }

    public ApplicationComponent withOsType(OsType osType) {
        this.osType = osType.toString();
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public ApplicationComponent withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public ApplicationComponent withTier(Tier tier) {
        this.tier = tier.toString();
        return this;
    }

    public void setMonitor(Boolean monitor) {
        this.monitor = monitor;
    }

    public Boolean getMonitor() {
        return this.monitor;
    }

    public ApplicationComponent withMonitor(Boolean monitor) {
        this.setMonitor(monitor);
        return this;
    }

    public Boolean isMonitor() {
        return this.monitor;
    }

    public Map<String, Map<String, String>> getDetectedWorkload() {
        return this.detectedWorkload;
    }

    public void setDetectedWorkload(Map<String, Map<String, String>> detectedWorkload) {
        this.detectedWorkload = detectedWorkload;
    }

    public ApplicationComponent withDetectedWorkload(Map<String, Map<String, String>> detectedWorkload) {
        this.setDetectedWorkload(detectedWorkload);
        return this;
    }

    public ApplicationComponent addDetectedWorkloadEntry(String key, Map<String, String> value) {
        if (null == this.detectedWorkload) {
            this.detectedWorkload = new HashMap<String, Map<String, String>>();
        }
        if (this.detectedWorkload.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.detectedWorkload.put(key, value);
        return this;
    }

    public ApplicationComponent clearDetectedWorkloadEntries() {
        this.detectedWorkload = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentName() != null) {
            sb.append("ComponentName: ").append(this.getComponentName()).append(",");
        }
        if (this.getComponentRemarks() != null) {
            sb.append("ComponentRemarks: ").append(this.getComponentRemarks()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getOsType() != null) {
            sb.append("OsType: ").append(this.getOsType()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getMonitor() != null) {
            sb.append("Monitor: ").append(this.getMonitor()).append(",");
        }
        if (this.getDetectedWorkload() != null) {
            sb.append("DetectedWorkload: ").append(this.getDetectedWorkload());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponent)) {
            return false;
        }
        ApplicationComponent other = (ApplicationComponent)obj;
        if (other.getComponentName() == null ^ this.getComponentName() == null) {
            return false;
        }
        if (other.getComponentName() != null && !other.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        if (other.getComponentRemarks() == null ^ this.getComponentRemarks() == null) {
            return false;
        }
        if (other.getComponentRemarks() != null && !other.getComponentRemarks().equals(this.getComponentRemarks())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getOsType() == null ^ this.getOsType() == null) {
            return false;
        }
        if (other.getOsType() != null && !other.getOsType().equals(this.getOsType())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getMonitor() == null ^ this.getMonitor() == null) {
            return false;
        }
        if (other.getMonitor() != null && !other.getMonitor().equals(this.getMonitor())) {
            return false;
        }
        if (other.getDetectedWorkload() == null ^ this.getDetectedWorkload() == null) {
            return false;
        }
        return other.getDetectedWorkload() == null || other.getDetectedWorkload().equals(this.getDetectedWorkload());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentName() == null ? 0 : this.getComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getComponentRemarks() == null ? 0 : this.getComponentRemarks().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getOsType() == null ? 0 : this.getOsType().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getMonitor() == null ? 0 : this.getMonitor().hashCode());
        hashCode = 31 * hashCode + (this.getDetectedWorkload() == null ? 0 : this.getDetectedWorkload().hashCode());
        return hashCode;
    }

    public ApplicationComponent clone() {
        try {
            return (ApplicationComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationComponentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

