/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appintegrations.model.transform.ExternalUrlConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternalUrlConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessUrl;
    private List<String> approvedOrigins;

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public ExternalUrlConfig withAccessUrl(String accessUrl) {
        this.setAccessUrl(accessUrl);
        return this;
    }

    public List<String> getApprovedOrigins() {
        return this.approvedOrigins;
    }

    public void setApprovedOrigins(Collection<String> approvedOrigins) {
        if (approvedOrigins == null) {
            this.approvedOrigins = null;
            return;
        }
        this.approvedOrigins = new ArrayList<String>(approvedOrigins);
    }

    public ExternalUrlConfig withApprovedOrigins(String ... approvedOrigins) {
        if (this.approvedOrigins == null) {
            this.setApprovedOrigins(new ArrayList<String>(approvedOrigins.length));
        }
        for (String ele : approvedOrigins) {
            this.approvedOrigins.add(ele);
        }
        return this;
    }

    public ExternalUrlConfig withApprovedOrigins(Collection<String> approvedOrigins) {
        this.setApprovedOrigins(approvedOrigins);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessUrl() != null) {
            sb.append("AccessUrl: ").append(this.getAccessUrl()).append(",");
        }
        if (this.getApprovedOrigins() != null) {
            sb.append("ApprovedOrigins: ").append(this.getApprovedOrigins());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalUrlConfig)) {
            return false;
        }
        ExternalUrlConfig other = (ExternalUrlConfig)obj;
        if (other.getAccessUrl() == null ^ this.getAccessUrl() == null) {
            return false;
        }
        if (other.getAccessUrl() != null && !other.getAccessUrl().equals(this.getAccessUrl())) {
            return false;
        }
        if (other.getApprovedOrigins() == null ^ this.getApprovedOrigins() == null) {
            return false;
        }
        return other.getApprovedOrigins() == null || other.getApprovedOrigins().equals(this.getApprovedOrigins());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessUrl() == null ? 0 : this.getAccessUrl().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedOrigins() == null ? 0 : this.getApprovedOrigins().hashCode());
        return hashCode;
    }

    public ExternalUrlConfig clone() {
        try {
            return (ExternalUrlConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalUrlConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

