/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appfabric.model.IngestionType;
import com.amazonaws.services.appfabric.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIngestionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appBundleIdentifier;
    private String app;
    private String tenantId;
    private String ingestionType;
    private String clientToken;
    private List<Tag> tags;

    public void setAppBundleIdentifier(String appBundleIdentifier) {
        this.appBundleIdentifier = appBundleIdentifier;
    }

    public String getAppBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public CreateIngestionRequest withAppBundleIdentifier(String appBundleIdentifier) {
        this.setAppBundleIdentifier(appBundleIdentifier);
        return this;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public CreateIngestionRequest withApp(String app) {
        this.setApp(app);
        return this;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public CreateIngestionRequest withTenantId(String tenantId) {
        this.setTenantId(tenantId);
        return this;
    }

    public void setIngestionType(String ingestionType) {
        this.ingestionType = ingestionType;
    }

    public String getIngestionType() {
        return this.ingestionType;
    }

    public CreateIngestionRequest withIngestionType(String ingestionType) {
        this.setIngestionType(ingestionType);
        return this;
    }

    public CreateIngestionRequest withIngestionType(IngestionType ingestionType) {
        this.ingestionType = ingestionType.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIngestionRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateIngestionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateIngestionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppBundleIdentifier() != null) {
            sb.append("AppBundleIdentifier: ").append(this.getAppBundleIdentifier()).append(",");
        }
        if (this.getApp() != null) {
            sb.append("App: ").append(this.getApp()).append(",");
        }
        if (this.getTenantId() != null) {
            sb.append("TenantId: ").append(this.getTenantId()).append(",");
        }
        if (this.getIngestionType() != null) {
            sb.append("IngestionType: ").append(this.getIngestionType()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionRequest)) {
            return false;
        }
        CreateIngestionRequest other = (CreateIngestionRequest)obj;
        if (other.getAppBundleIdentifier() == null ^ this.getAppBundleIdentifier() == null) {
            return false;
        }
        if (other.getAppBundleIdentifier() != null && !other.getAppBundleIdentifier().equals(this.getAppBundleIdentifier())) {
            return false;
        }
        if (other.getApp() == null ^ this.getApp() == null) {
            return false;
        }
        if (other.getApp() != null && !other.getApp().equals(this.getApp())) {
            return false;
        }
        if (other.getTenantId() == null ^ this.getTenantId() == null) {
            return false;
        }
        if (other.getTenantId() != null && !other.getTenantId().equals(this.getTenantId())) {
            return false;
        }
        if (other.getIngestionType() == null ^ this.getIngestionType() == null) {
            return false;
        }
        if (other.getIngestionType() != null && !other.getIngestionType().equals(this.getIngestionType())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppBundleIdentifier() == null ? 0 : this.getAppBundleIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getApp() == null ? 0 : this.getApp().hashCode());
        hashCode = 31 * hashCode + (this.getTenantId() == null ? 0 : this.getTenantId().hashCode());
        hashCode = 31 * hashCode + (this.getIngestionType() == null ? 0 : this.getIngestionType().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateIngestionRequest clone() {
        return (CreateIngestionRequest)super.clone();
    }
}

