/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.TestInvokeAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class TestInvokeAuthorizerRequestMarshaller
implements Marshaller<Request<TestInvokeAuthorizerRequest>, TestInvokeAuthorizerRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public TestInvokeAuthorizerRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TestInvokeAuthorizerRequest> marshall(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        if (testInvokeAuthorizerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testInvokeAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers/{authorizer_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", testInvokeAuthorizerRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)testInvokeAuthorizerRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{authorizer_id}", testInvokeAuthorizerRequest.getAuthorizerId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)testInvokeAuthorizerRequest.getAuthorizerId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> additionalContextMap;
            Map<String, String> stageVariablesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            Map<String, String> headersMap = testInvokeAuthorizerRequest.getHeaders();
            if (headersMap != null) {
                jsonGenerator.writeFieldName("headers");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(headersMapValue.getKey());
                    jsonGenerator.writeValue(headersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (testInvokeAuthorizerRequest.getPathWithQueryString() != null) {
                jsonGenerator.writeFieldName("pathWithQueryString").writeValue(testInvokeAuthorizerRequest.getPathWithQueryString());
            }
            if (testInvokeAuthorizerRequest.getBody() != null) {
                jsonGenerator.writeFieldName("body").writeValue(testInvokeAuthorizerRequest.getBody());
            }
            if ((stageVariablesMap = testInvokeAuthorizerRequest.getStageVariables()) != null) {
                jsonGenerator.writeFieldName("stageVariables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> stageVariablesMapValue : stageVariablesMap.entrySet()) {
                    if (stageVariablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(stageVariablesMapValue.getKey());
                    jsonGenerator.writeValue(stageVariablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((additionalContextMap = testInvokeAuthorizerRequest.getAdditionalContext()) != null) {
                jsonGenerator.writeFieldName("additionalContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> additionalContextMapValue : additionalContextMap.entrySet()) {
                    if (additionalContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(additionalContextMapValue.getKey());
                    jsonGenerator.writeValue(additionalContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

