/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class PutRestApiRequestMarshaller
implements Marshaller<Request<PutRestApiRequest>, PutRestApiRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<PutRestApiRequest> marshall(PutRestApiRequest putRestApiRequest) {
        if (putRestApiRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putRestApiRequest.getRestApiId() != null ? StringUtils.fromString((String)putRestApiRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (putRestApiRequest.getMode() != null) {
            request.addParameter("mode", StringUtils.fromString((String)putRestApiRequest.getMode()));
        }
        if (putRestApiRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean((Boolean)putRestApiRequest.getFailOnWarnings()));
        }
        Map<String, String> parameters = putRestApiRequest.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            request.addParameter(StringUtils.fromString((String)entry.getKey()), StringUtils.fromString((String)entry.getValue()));
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)putRestApiRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

