/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.apigateway.model.transform;

import java.util.Map;
import java.util.Map.Entry;

import com.amazonaws.services.apigateway.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetMethodResult JSON Unmarshaller
 */
public class GetMethodResultJsonUnmarshaller implements
        Unmarshaller<GetMethodResult, JsonUnmarshallerContext> {

    public GetMethodResult unmarshall(JsonUnmarshallerContext context)
            throws Exception {
        GetMethodResult getMethodResult = new GetMethodResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL)
            return null;

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("httpMethod", targetDepth)) {
                    context.nextToken();
                    getMethodResult.setHttpMethod(StringJsonUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("authorizationType", targetDepth)) {
                    context.nextToken();
                    getMethodResult.setAuthorizationType(StringJsonUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("apiKeyRequired", targetDepth)) {
                    context.nextToken();
                    getMethodResult.setApiKeyRequired(BooleanJsonUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestParameters", targetDepth)) {
                    context.nextToken();
                    getMethodResult
                            .setRequestParameters(new MapUnmarshaller<String, Boolean>(
                                    StringJsonUnmarshaller.getInstance(),
                                    BooleanJsonUnmarshaller.getInstance())
                                    .unmarshall(context));
                }
                if (context.testExpression("requestModels", targetDepth)) {
                    context.nextToken();
                    getMethodResult
                            .setRequestModels(new MapUnmarshaller<String, String>(
                                    StringJsonUnmarshaller.getInstance(),
                                    StringJsonUnmarshaller.getInstance())
                                    .unmarshall(context));
                }
                if (context.testExpression("methodResponses", targetDepth)) {
                    context.nextToken();
                    getMethodResult
                            .setMethodResponses(new MapUnmarshaller<String, MethodResponse>(
                                    StringJsonUnmarshaller.getInstance(),
                                    MethodResponseJsonUnmarshaller
                                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("methodIntegration", targetDepth)) {
                    context.nextToken();
                    getMethodResult
                            .setMethodIntegration(IntegrationJsonUnmarshaller
                                    .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(
                                currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getMethodResult;
    }

    private static GetMethodResultJsonUnmarshaller instance;

    public static GetMethodResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetMethodResultJsonUnmarshaller();
        return instance;
    }
}
