/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.alexaforbusiness.model.Ssml;

@SdkInternalApi
public class SsmlMarshaller {
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final SsmlMarshaller instance = new SsmlMarshaller();

    public static SsmlMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ssml ssml, ProtocolMarshaller protocolMarshaller) {
        if (ssml == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ssml.getLocale(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)ssml.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

