/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.GeneralName;

@SdkInternalApi
public class GeneralNameMarshaller {
    private static final MarshallingInfo<StructuredPojo> OTHERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherName").build();
    private static final MarshallingInfo<String> RFC822NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rfc822Name").build();
    private static final MarshallingInfo<String> DNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsName").build();
    private static final MarshallingInfo<StructuredPojo> DIRECTORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryName").build();
    private static final MarshallingInfo<StructuredPojo> EDIPARTYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EdiPartyName").build();
    private static final MarshallingInfo<String> UNIFORMRESOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniformResourceIdentifier").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").build();
    private static final MarshallingInfo<String> REGISTEREDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredId").build();
    private static final GeneralNameMarshaller instance = new GeneralNameMarshaller();

    public static GeneralNameMarshaller getInstance() {
        return instance;
    }

    public void marshall(GeneralName generalName, ProtocolMarshaller protocolMarshaller) {
        if (generalName == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)generalName.getOtherName(), OTHERNAME_BINDING);
            protocolMarshaller.marshall((Object)generalName.getRfc822Name(), RFC822NAME_BINDING);
            protocolMarshaller.marshall((Object)generalName.getDnsName(), DNSNAME_BINDING);
            protocolMarshaller.marshall((Object)generalName.getDirectoryName(), DIRECTORYNAME_BINDING);
            protocolMarshaller.marshall((Object)generalName.getEdiPartyName(), EDIPARTYNAME_BINDING);
            protocolMarshaller.marshall((Object)generalName.getUniformResourceIdentifier(), UNIFORMRESOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)generalName.getIpAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)generalName.getRegisteredId(), REGISTEREDID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

