/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.services.certificatemanager.model.RenewalSummary;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationJsonMarshaller;
import java.util.List;

public class RenewalSummaryJsonMarshaller {
    private static RenewalSummaryJsonMarshaller instance;

    public void marshall(RenewalSummary renewalSummary, StructuredJsonGenerator jsonGenerator) {
        if (renewalSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<DomainValidation> domainValidationOptionsList;
            jsonGenerator.writeStartObject();
            if (renewalSummary.getRenewalStatus() != null) {
                jsonGenerator.writeFieldName("RenewalStatus").writeValue(renewalSummary.getRenewalStatus());
            }
            if ((domainValidationOptionsList = renewalSummary.getDomainValidationOptions()) != null) {
                jsonGenerator.writeFieldName("DomainValidationOptions");
                jsonGenerator.writeStartArray();
                for (DomainValidation domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RenewalSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RenewalSummaryJsonMarshaller();
        }
        return instance;
    }
}

