/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.certificatemanager.model.CertificateDetail;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class CertificateDetailJsonMarshaller {
    private static CertificateDetailJsonMarshaller instance;

    public void marshall(CertificateDetail certificateDetail, JSONWriter jsonWriter) {
        if (certificateDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> inUseByList;
            List<DomainValidation> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            jsonWriter.object();
            if (certificateDetail.getCertificateArn() != null) {
                jsonWriter.key("CertificateArn").value((Object)certificateDetail.getCertificateArn());
            }
            if (certificateDetail.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)certificateDetail.getDomainName());
            }
            if ((subjectAlternativeNamesList = certificateDetail.getSubjectAlternativeNames()) != null) {
                jsonWriter.key("SubjectAlternativeNames");
                jsonWriter.array();
                for (String subjectAlternativeNamesListValue : subjectAlternativeNamesList) {
                    if (subjectAlternativeNamesListValue == null) continue;
                    jsonWriter.value((Object)subjectAlternativeNamesListValue);
                }
                jsonWriter.endArray();
            }
            if ((domainValidationOptionsList = certificateDetail.getDomainValidationOptions()) != null) {
                jsonWriter.key("DomainValidationOptions");
                jsonWriter.array();
                for (DomainValidation domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (certificateDetail.getSerial() != null) {
                jsonWriter.key("Serial").value((Object)certificateDetail.getSerial());
            }
            if (certificateDetail.getSubject() != null) {
                jsonWriter.key("Subject").value((Object)certificateDetail.getSubject());
            }
            if (certificateDetail.getIssuer() != null) {
                jsonWriter.key("Issuer").value((Object)certificateDetail.getIssuer());
            }
            if (certificateDetail.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(certificateDetail.getCreatedAt());
            }
            if (certificateDetail.getIssuedAt() != null) {
                jsonWriter.key("IssuedAt").value(certificateDetail.getIssuedAt());
            }
            if (certificateDetail.getStatus() != null) {
                jsonWriter.key("Status").value((Object)certificateDetail.getStatus());
            }
            if (certificateDetail.getRevokedAt() != null) {
                jsonWriter.key("RevokedAt").value(certificateDetail.getRevokedAt());
            }
            if (certificateDetail.getRevocationReason() != null) {
                jsonWriter.key("RevocationReason").value((Object)certificateDetail.getRevocationReason());
            }
            if (certificateDetail.getNotBefore() != null) {
                jsonWriter.key("NotBefore").value(certificateDetail.getNotBefore());
            }
            if (certificateDetail.getNotAfter() != null) {
                jsonWriter.key("NotAfter").value(certificateDetail.getNotAfter());
            }
            if (certificateDetail.getKeyAlgorithm() != null) {
                jsonWriter.key("KeyAlgorithm").value((Object)certificateDetail.getKeyAlgorithm());
            }
            if (certificateDetail.getSignatureAlgorithm() != null) {
                jsonWriter.key("SignatureAlgorithm").value((Object)certificateDetail.getSignatureAlgorithm());
            }
            if ((inUseByList = certificateDetail.getInUseBy()) != null) {
                jsonWriter.key("InUseBy");
                jsonWriter.array();
                for (String inUseByListValue : inUseByList) {
                    if (inUseByListValue == null) continue;
                    jsonWriter.value((Object)inUseByListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CertificateDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CertificateDetailJsonMarshaller();
        }
        return instance;
    }
}

