/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.certificatemanager.model.DomainValidationOption;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationOptionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class RequestCertificateRequestMarshaller
implements Marshaller<Request<RequestCertificateRequest>, RequestCertificateRequest> {
    public Request<RequestCertificateRequest> marshall(RequestCertificateRequest requestCertificateRequest) {
        if (requestCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestCertificateRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.RequestCertificate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<DomainValidationOption> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (requestCertificateRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)requestCertificateRequest.getDomainName());
            }
            if ((subjectAlternativeNamesList = requestCertificateRequest.getSubjectAlternativeNames()) != null) {
                jsonWriter.key("SubjectAlternativeNames");
                jsonWriter.array();
                for (String subjectAlternativeNamesListValue : subjectAlternativeNamesList) {
                    if (subjectAlternativeNamesListValue == null) continue;
                    jsonWriter.value((Object)subjectAlternativeNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (requestCertificateRequest.getIdempotencyToken() != null) {
                jsonWriter.key("IdempotencyToken").value((Object)requestCertificateRequest.getIdempotencyToken());
            }
            if ((domainValidationOptionsList = requestCertificateRequest.getDomainValidationOptions()) != null) {
                jsonWriter.key("DomainValidationOptions");
                jsonWriter.array();
                for (DomainValidationOption domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationOptionJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

