/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.AnalyzedResource;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AnalyzedResourceMarshaller {
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<Date> ANALYZEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("analyzedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> ERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("error").build();
    private static final MarshallingInfo<Boolean> ISPUBLIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isPublic").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceArn").build();
    private static final MarshallingInfo<String> RESOURCEOWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceOwnerAccount").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<List> SHAREDVIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sharedVia").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("iso8601").build();
    private static final AnalyzedResourceMarshaller instance = new AnalyzedResourceMarshaller();

    public static AnalyzedResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnalyzedResource analyzedResource, ProtocolMarshaller protocolMarshaller) {
        if (analyzedResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(analyzedResource.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getAnalyzedAt(), ANALYZEDAT_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getError(), ERROR_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getIsPublic(), ISPUBLIC_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getResourceOwnerAccount(), RESOURCEOWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(analyzedResource.getSharedVia(), SHAREDVIA_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)analyzedResource.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

