/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.core;

import com.amazonaws.services.iot.client.AWSIotConnectionStatus;
import com.amazonaws.services.iot.client.AWSIotDevice;
import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.AWSIotTopic;
import com.amazonaws.services.iot.client.core.AwsIotCompletion;
import com.amazonaws.services.iot.client.core.AwsIotConnection;
import com.amazonaws.services.iot.client.core.AwsIotConnectionCallback;
import com.amazonaws.services.iot.client.core.AwsIotConnectionType;
import com.amazonaws.services.iot.client.core.AwsIotRuntimeException;
import com.amazonaws.services.iot.client.core.AwsIotTlsConnection;
import com.amazonaws.services.iot.client.core.AwsIotWebsocketConnection;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import java.security.KeyStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class AbstractAwsIotClient
implements AwsIotConnectionCallback {
    private static final Logger LOGGER = Logger.getLogger(AbstractAwsIotClient.class.getName());
    protected final String clientId;
    protected final String clientEndpoint;
    protected final AwsIotConnectionType connectionType;
    protected int numOfClientThreads = 1;
    protected int connectionTimeout = 30000;
    protected int serverAckTimeout = 3000;
    protected int keepAliveInterval = 30000;
    protected int maxConnectionRetries = 5;
    protected int baseRetryDelay = 3000;
    protected int maxRetryDelay = 30000;
    protected int maxOfflineQueueSize = 64;
    protected AWSIotMessage willMessage;
    private final ConcurrentMap<String, AWSIotTopic> subscriptions = new ConcurrentHashMap<String, AWSIotTopic>();
    private final ConcurrentMap<String, AbstractAwsIotDevice> devices = new ConcurrentHashMap<String, AbstractAwsIotDevice>();
    private final AwsIotConnection connection;
    private ScheduledExecutorService executionService;

    protected AbstractAwsIotClient(String clientEndpoint, String clientId, KeyStore keyStore, String keyPassword) {
        this.clientEndpoint = clientEndpoint;
        this.clientId = clientId;
        this.connectionType = AwsIotConnectionType.MQTT_OVER_TLS;
        try {
            this.connection = new AwsIotTlsConnection(this, keyStore, keyPassword);
        }
        catch (AWSIotException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    protected AbstractAwsIotClient(String clientEndpoint, String clientId, String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
        this.clientEndpoint = clientEndpoint;
        this.clientId = clientId;
        this.connectionType = AwsIotConnectionType.MQTT_OVER_WEBSOCKET;
        try {
            this.connection = new AwsIotWebsocketConnection(this, awsAccessKeyId, awsSecretAccessKey, sessionToken);
        }
        catch (AWSIotException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    AbstractAwsIotClient(String clientEndpoint, String clientId, AwsIotConnection connection) {
        this.clientEndpoint = clientEndpoint;
        this.clientId = clientId;
        this.connection = connection;
        this.connectionType = null;
    }

    public void updateCredentials(String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
        this.connection.updateCredentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
    }

    public void connect() throws AWSIotException {
        try {
            this.connect(0L, true);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void connect(long timeout) throws AWSIotException, AWSIotTimeoutException {
        this.connect(timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long timeout, boolean blocking) throws AWSIotException, AWSIotTimeoutException {
        AbstractAwsIotClient abstractAwsIotClient = this;
        synchronized (abstractAwsIotClient) {
            if (this.executionService == null) {
                this.executionService = Executors.newScheduledThreadPool(this.numOfClientThreads);
            }
        }
        AwsIotCompletion completion = new AwsIotCompletion(timeout, !blocking);
        this.connection.connect(completion);
        completion.get(this);
    }

    public void disconnect() throws AWSIotException {
        try {
            this.disconnect(0L, true);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void disconnect(long timeout) throws AWSIotException, AWSIotTimeoutException {
        this.disconnect(timeout, true);
    }

    public void disconnect(long timeout, boolean blocking) throws AWSIotException, AWSIotTimeoutException {
        AwsIotCompletion completion = new AwsIotCompletion(timeout, !blocking);
        this.connection.disconnect(completion);
        completion.get(this);
    }

    public void publish(String topic, String payload) throws AWSIotException {
        this.publish(topic, AWSIotQos.QOS0, payload);
    }

    public void publish(String topic, String payload, long timeout) throws AWSIotException, AWSIotTimeoutException {
        this.publish(topic, AWSIotQos.QOS0, payload, timeout);
    }

    public void publish(String topic, AWSIotQos qos, String payload) throws AWSIotException {
        try {
            this.publish(topic, qos, payload, 0L);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void publish(String topic, AWSIotQos qos, String payload, long timeout) throws AWSIotException, AWSIotTimeoutException {
        AwsIotCompletion completion = new AwsIotCompletion(topic, qos, payload, timeout);
        this.connection.publish(completion);
        completion.get(this);
    }

    public void publish(String topic, byte[] payload) throws AWSIotException {
        this.publish(topic, AWSIotQos.QOS0, payload);
    }

    public void publish(String topic, byte[] payload, long timeout) throws AWSIotException, AWSIotTimeoutException {
        this.publish(topic, AWSIotQos.QOS0, payload, timeout);
    }

    public void publish(String topic, AWSIotQos qos, byte[] payload) throws AWSIotException {
        try {
            this.publish(topic, qos, payload, 0L);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void publish(String topic, AWSIotQos qos, byte[] payload, long timeout) throws AWSIotException, AWSIotTimeoutException {
        AwsIotCompletion completion = new AwsIotCompletion(topic, qos, payload, timeout);
        this.connection.publish(completion);
        completion.get(this);
    }

    public void publish(AWSIotMessage message) throws AWSIotException {
        this.publish(message, 0L);
    }

    public void publish(AWSIotMessage message, long timeout) throws AWSIotException {
        AwsIotCompletion completion = new AwsIotCompletion(message, timeout, true);
        this.connection.publish(completion);
        try {
            completion.get(this);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void subscribe(AWSIotTopic topic, boolean blocking) throws AWSIotException {
        try {
            this._subscribe(topic, 0L, !blocking);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void subscribe(AWSIotTopic topic, long timeout, boolean blocking) throws AWSIotException, AWSIotTimeoutException {
        this._subscribe(topic, timeout, !blocking);
    }

    public void subscribe(AWSIotTopic topic) throws AWSIotException {
        this.subscribe(topic, 0L);
    }

    public void subscribe(AWSIotTopic topic, long timeout) throws AWSIotException {
        try {
            this._subscribe(topic, timeout, true);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    private void _subscribe(AWSIotTopic topic, long timeout, boolean async) throws AWSIotException, AWSIotTimeoutException {
        AwsIotCompletion completion = new AwsIotCompletion(topic, timeout, async);
        this.connection.subscribe(completion);
        completion.get(this);
        this.subscriptions.put(topic.getTopic(), topic);
    }

    public void unsubscribe(String topic) throws AWSIotException {
        try {
            this.unsubscribe(topic, 0L);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public void unsubscribe(String topic, long timeout) throws AWSIotException, AWSIotTimeoutException {
        if (this.subscriptions.remove(topic) == null) {
            return;
        }
        AwsIotCompletion completion = new AwsIotCompletion(topic, AWSIotQos.QOS0, timeout);
        this.connection.unsubscribe(completion);
        completion.get(this);
    }

    public void unsubscribe(AWSIotTopic topic) throws AWSIotException {
        this.unsubscribe(topic, 0L);
    }

    public void unsubscribe(AWSIotTopic topic, long timeout) throws AWSIotException {
        if (this.subscriptions.remove(topic.getTopic()) == null) {
            return;
        }
        AwsIotCompletion completion = new AwsIotCompletion(topic, timeout, true);
        this.connection.unsubscribe(completion);
        try {
            completion.get(this);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public boolean topicFilterMatch(String topicFilter, String topic) {
        String[] topicTokens;
        if (topicFilter == null || topic == null) {
            return false;
        }
        String[] filterTokens = topicFilter.split("/");
        if (filterTokens.length > (topicTokens = topic.split("/")).length) {
            return false;
        }
        for (int i = 0; i < filterTokens.length; ++i) {
            if (filterTokens[i].equals("#")) {
                return i + 1 == filterTokens.length;
            }
            if (filterTokens[i].equals(topicTokens[i]) || filterTokens[i].equals("+")) continue;
            return false;
        }
        return filterTokens.length == topicTokens.length;
    }

    public void dispatch(final AWSIotMessage message) {
        boolean matches = false;
        for (String topicFilter : this.subscriptions.keySet()) {
            if (!this.topicFilterMatch(topicFilter, message.getTopic())) continue;
            final AWSIotTopic topic = (AWSIotTopic)this.subscriptions.get(topicFilter);
            this.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    topic.onMessage(message);
                }
            });
            matches = true;
        }
        if (!matches) {
            LOGGER.warning("Unexpected message received from topic " + message.getTopic());
        }
    }

    public void attach(AWSIotDevice device) throws AWSIotException {
        if (this.devices.putIfAbsent(device.getThingName(), device) != null) {
            return;
        }
        device.setClient(this);
        if (this.getConnectionStatus().equals((Object)AWSIotConnectionStatus.CONNECTED)) {
            device.activate();
        }
    }

    public void detach(AWSIotDevice device) throws AWSIotException {
        if (this.devices.remove(device.getThingName()) == null) {
            return;
        }
        device.deactivate();
    }

    public AWSIotConnectionStatus getConnectionStatus() {
        if (this.connection != null) {
            return this.connection.getConnectionStatus();
        }
        return AWSIotConnectionStatus.DISCONNECTED;
    }

    @Override
    public void onConnectionSuccess() {
        LOGGER.info("Client connection active: " + this.clientId);
        try {
            for (AWSIotTopic topic : this.subscriptions.values()) {
                this.subscribe(topic, this.serverAckTimeout);
            }
            for (AbstractAwsIotDevice device : this.devices.values()) {
                device.activate();
            }
        }
        catch (AWSIotException e) {
            LOGGER.warning("Failed to complete subscriptions while client is active, will disconnect");
            try {
                this.connection.disconnect(null);
            }
            catch (AWSIotException aWSIotException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onConnectionFailure() {
        LOGGER.info("Client connection lost: " + this.clientId);
        for (AbstractAwsIotDevice device : this.devices.values()) {
            try {
                device.deactivate();
            }
            catch (AWSIotException e) {
                LOGGER.warning("Failed to deactive all the devices, ignoring the error");
            }
        }
    }

    @Override
    public void onConnectionClosed() {
        LOGGER.info("Client connection closed: " + this.clientId);
        for (AbstractAwsIotDevice device : this.devices.values()) {
            try {
                device.deactivate();
            }
            catch (AWSIotException e) {
                LOGGER.warning("Failed to deactive all the devices, ignoring the error");
            }
        }
        this.subscriptions.clear();
        this.devices.clear();
        this.executionService.shutdown();
    }

    public Future<?> scheduleTask(Runnable runnable) {
        return this.scheduleTimeoutTask(runnable, 0L);
    }

    public Future<?> scheduleTimeoutTask(Runnable runnable, long timeout) {
        if (this.executionService == null) {
            throw new AwsIotRuntimeException("Client is not connected");
        }
        return this.executionService.schedule(runnable, timeout, TimeUnit.MILLISECONDS);
    }

    public Future<?> scheduleRoutineTask(Runnable runnable, long initialDelay, long period) {
        if (this.executionService == null) {
            throw new AwsIotRuntimeException("Client is not connected");
        }
        return this.executionService.scheduleAtFixedRate(runnable, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    public AwsIotConnectionType getConnectionType() {
        return this.connectionType;
    }

    public int getNumOfClientThreads() {
        return this.numOfClientThreads;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getServerAckTimeout() {
        return this.serverAckTimeout;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public int getMaxConnectionRetries() {
        return this.maxConnectionRetries;
    }

    public int getBaseRetryDelay() {
        return this.baseRetryDelay;
    }

    public int getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public int getMaxOfflineQueueSize() {
        return this.maxOfflineQueueSize;
    }

    public AWSIotMessage getWillMessage() {
        return this.willMessage;
    }

    public ConcurrentMap<String, AWSIotTopic> getSubscriptions() {
        return this.subscriptions;
    }

    public ConcurrentMap<String, AbstractAwsIotDevice> getDevices() {
        return this.devices;
    }

    public AwsIotConnection getConnection() {
        return this.connection;
    }

    public ScheduledExecutorService getExecutionService() {
        return this.executionService;
    }

    public void setNumOfClientThreads(int numOfClientThreads) {
        this.numOfClientThreads = numOfClientThreads;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setServerAckTimeout(int serverAckTimeout) {
        this.serverAckTimeout = serverAckTimeout;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setMaxConnectionRetries(int maxConnectionRetries) {
        this.maxConnectionRetries = maxConnectionRetries;
    }

    public void setBaseRetryDelay(int baseRetryDelay) {
        this.baseRetryDelay = baseRetryDelay;
    }

    public void setMaxRetryDelay(int maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public void setMaxOfflineQueueSize(int maxOfflineQueueSize) {
        this.maxOfflineQueueSize = maxOfflineQueueSize;
    }

    public void setWillMessage(AWSIotMessage willMessage) {
        this.willMessage = willMessage;
    }

    public void setExecutionService(ScheduledExecutorService executionService) {
        this.executionService = executionService;
    }
}

