/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.kms.KmsMasterKey;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class KmsMasterKeyProvider
extends MasterKeyProvider<KmsMasterKey>
implements KmsMethods {
    private static final String PROVIDER_NAME = "aws-kms";
    private final AWSKMS kms_;
    private final List<String> keyIds_;
    private final List<String> grantTokens_ = new ArrayList<String>();
    private Region region_;
    private String regionName_;

    public KmsMasterKeyProvider() {
        this((AWSKMS)new AWSKMSClient(), Region.getRegion((Regions)Regions.DEFAULT_REGION), Collections.emptyList());
    }

    public KmsMasterKeyProvider(String keyId) {
        this((AWSKMS)new AWSKMSClient(), KmsMasterKeyProvider.getStartingRegion(keyId), Collections.singletonList(keyId));
    }

    public KmsMasterKeyProvider(AWSCredentials creds, String keyId) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(creds), KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds, String keyId) {
        this(creds, KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    public KmsMasterKeyProvider(AWSCredentials creds) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(creds), Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds) {
        this(creds, Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, String keyId) {
        this((AWSKMS)new AWSKMSClient(creds, clientConfiguration), region, Collections.singletonList(keyId));
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, List<String> keyIds) {
        this((AWSKMS)new AWSKMSClient(creds, clientConfiguration), region, keyIds);
    }

    public KmsMasterKeyProvider(AWSKMS kms, Region region, List<String> keyIds) {
        this.kms_ = kms;
        this.region_ = region;
        this.regionName_ = region.getName();
        this.kms_.setRegion(region);
        this.keyIds_ = new ArrayList<String>(keyIds);
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public KmsMasterKey getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException();
        }
        KmsMasterKey result = KmsMasterKey.getInstance(this.kms_, keyId, this);
        result.setGrantTokens(this.grantTokens_);
        return result;
    }

    @Override
    public List<KmsMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.keyIds_ == null) {
            return Collections.emptyList();
        }
        ArrayList<KmsMasterKey> result = new ArrayList<KmsMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result.add((KmsMasterKey)this.getMasterKey(id));
        }
        return result;
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            if (!this.canProvide(encryptedDataKey.getProviderId())) continue;
            try {
                DataKey<KmsMasterKey> result;
                String keyArn = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8);
                String keyRegion = KmsMasterKeyProvider.parseRegionfromKeyArn(keyArn);
                if (!this.regionName_.equals(keyRegion) || (result = ((KmsMasterKey)this.getMasterKey(keyArn)).decryptDataKey(algorithm, Collections.singletonList(encryptedDataKey), encryptionContext)) == null) continue;
                return result;
            }
            catch (Exception asex) {
                exceptions.add(asex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    @Override
    public void setGrantTokens(List<String> grantTokens) {
        this.grantTokens_.clear();
        this.grantTokens_.addAll(grantTokens);
    }

    @Override
    public List<String> getGrantTokens() {
        return this.grantTokens_;
    }

    @Override
    public void addGrantToken(String grantToken) {
        this.grantTokens_.add(grantToken);
    }

    public void setCustomEndpoint(String regionName, String endPoint) {
        if (!(this.kms_ instanceof AWSKMSClient)) {
            throw new IllegalStateException("This method can only be called when kms is an instance of AWSKMSClient");
        }
        this.kms_.setEndpoint(endPoint);
        ((AWSKMSClient)this.kms_).setSignerRegionOverride(regionName);
        this.region_ = null;
        this.regionName_ = regionName;
    }

    public void setRegion(Region region) {
        this.kms_.setRegion(region);
        this.region_ = region;
        this.regionName_ = region.getName();
    }

    public Region getRegion() {
        return this.region_;
    }

    private static Region getStartingRegion(String keyArn) {
        String region = KmsMasterKeyProvider.parseRegionfromKeyArn(keyArn);
        if (region != null) {
            return Region.getRegion((Regions)Regions.fromName((String)region));
        }
        Region currentRegion = Regions.getCurrentRegion();
        if (currentRegion != null) {
            return currentRegion;
        }
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    private static String parseRegionfromKeyArn(String keyArn) {
        String[] parts = keyArn.split(":", 5);
        if (!parts[0].equals("arn")) {
            return null;
        }
        if (!parts[2].equals("kms")) {
            return null;
        }
        return parts[3];
    }
}

