/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Utils {
    private Utils() {
    }

    public static <T> T assertNonNull(T object, String paramName) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(paramName + " must not be null");
        }
        return object;
    }

    public static byte[] truncate(byte[] arr, int len) throws IllegalArgumentException {
        if (arr.length == len) {
            return arr;
        }
        if (arr.length > len) {
            return Arrays.copyOf(arr, len);
        }
        throw new IllegalArgumentException("arr is not at least " + len + " elements long");
    }

    static byte[] generateContentAad(byte[] messageId, String idString, int seqNum, long len) {
        byte[] idBytes = idString.getBytes(StandardCharsets.UTF_8);
        int aadLen = messageId.length + idBytes.length + 4 + 8;
        ByteBuffer aad = ByteBuffer.allocate(aadLen);
        aad.put(messageId);
        aad.put(idBytes);
        aad.putInt(seqNum);
        aad.putLong(len);
        return aad.array();
    }
}

