/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

class CipherHandler {
    private final Cipher cipher_;

    CipherHandler(SecretKey key, byte[] nonce, byte[] contentAad, int cipherMode, CryptoAlgorithm cryptoAlgorithm) {
        if (nonce.length != cryptoAlgorithm.getNonceLen()) {
            throw new IllegalArgumentException("Invalid nonce length: " + nonce.length);
        }
        GCMParameterSpec spec = new GCMParameterSpec(cryptoAlgorithm.getTagLen() * 8, nonce, 0, nonce.length);
        try {
            this.cipher_ = CipherHandler.buildCipherObject(cryptoAlgorithm);
            this.cipher_.init(cipherMode, (Key)key, spec);
            if (contentAad != null) {
                this.cipher_.updateAAD(contentAad);
            }
        }
        catch (GeneralSecurityException gsx) {
            throw new AwsCryptoException(gsx);
        }
    }

    private static Cipher buildCipherObject(CryptoAlgorithm alg) {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Java does not support the requested algorithm", ex);
        }
    }

    synchronized byte[] cipherData(byte[] content, int off, int len) throws BadCiphertextException {
        int cipherOutLen = this.cipher_.getOutputSize(len);
        byte[] cipherOut = new byte[cipherOutLen];
        try {
            int processedSize = this.cipher_.update(content, off, len, cipherOut, 0);
            this.cipher_.doFinal(cipherOut, processedSize);
        }
        catch (GeneralSecurityException e) {
            throw new BadCiphertextException(e);
        }
        return cipherOut;
    }
}

