/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DelegatedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionFlags;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.AttributeValueMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class DynamoDBSigner {
    private static final ConcurrentHashMap<String, DynamoDBSigner> cache = new ConcurrentHashMap();
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    private final SecureRandom rnd;
    private final SecretKey hmacComparisonKey;
    private final String signingAlgorithm;

    static DynamoDBSigner getInstance(String signingAlgorithm, SecureRandom rnd) {
        DynamoDBSigner result = cache.get(signingAlgorithm);
        if (result == null) {
            result = new DynamoDBSigner(signingAlgorithm, rnd);
            cache.putIfAbsent(signingAlgorithm, result);
        }
        return result;
    }

    private DynamoDBSigner(String signingAlgorithm, SecureRandom rnd) {
        if (rnd == null) {
            rnd = Utils.getRng();
        }
        this.rnd = rnd;
        this.signingAlgorithm = signingAlgorithm;
        byte[] tmpKey = new byte[31];
        rnd.nextBytes(tmpKey);
        this.hmacComparisonKey = new SecretKeySpec(tmpKey, "HmacSHA256");
    }

    void verifySignature(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData, Key verificationKey, ByteBuffer signature) throws GeneralSecurityException {
        if (verificationKey instanceof DelegatedKey) {
            DelegatedKey dKey = (DelegatedKey)verificationKey;
            byte[] stringToSign = DynamoDBSigner.calculateStringToSign(itemAttributes, attributeFlags, associatedData);
            if (!dKey.verify(stringToSign, DynamoDBSigner.toByteArray(signature), dKey.getAlgorithm())) {
                throw new SignatureException("Bad signature");
            }
        } else if (verificationKey instanceof SecretKey) {
            byte[] calculatedSig = this.calculateSignature(itemAttributes, attributeFlags, associatedData, (SecretKey)verificationKey);
            if (!this.safeEquals(signature, calculatedSig)) {
                throw new SignatureException("Bad signature");
            }
        } else if (verificationKey instanceof PublicKey) {
            PublicKey integrityKey = (PublicKey)verificationKey;
            byte[] stringToSign = DynamoDBSigner.calculateStringToSign(itemAttributes, attributeFlags, associatedData);
            Signature sig = Signature.getInstance(this.getSigningAlgorithm());
            sig.initVerify(integrityKey);
            sig.update(stringToSign);
            if (!sig.verify(DynamoDBSigner.toByteArray(signature))) {
                throw new SignatureException("Bad signature");
            }
        } else {
            throw new IllegalArgumentException("No integrity key provided");
        }
    }

    static byte[] calculateStringToSign(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData) throws NoSuchAlgorithmException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArrayList<String> attrNames = new ArrayList<String>(itemAttributes.keySet());
            Collections.sort(attrNames);
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            if (associatedData != null) {
                out.write(sha256.digest(associatedData));
            } else {
                out.write(sha256.digest());
            }
            sha256.reset();
            for (String name : attrNames) {
                Set<EncryptionFlags> set = attributeFlags.get(name);
                if (set == null || !set.contains((Object)EncryptionFlags.SIGN)) continue;
                AttributeValue tmp = itemAttributes.get(name);
                out.write(sha256.digest(name.getBytes(UTF8)));
                sha256.reset();
                if (set.contains((Object)EncryptionFlags.ENCRYPT)) {
                    sha256.update("ENCRYPTED".getBytes(UTF8));
                } else {
                    sha256.update("PLAINTEXT".getBytes(UTF8));
                }
                out.write(sha256.digest());
                sha256.reset();
                sha256.update(AttributeValueMarshaller.marshall(tmp));
                out.write(sha256.digest());
                sha256.reset();
            }
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    byte[] calculateSignature(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData, Key key) throws GeneralSecurityException {
        if (key instanceof DelegatedKey) {
            return this.calculateSignature(itemAttributes, attributeFlags, associatedData, (DelegatedKey)key);
        }
        if (key instanceof SecretKey) {
            return this.calculateSignature(itemAttributes, attributeFlags, associatedData, (SecretKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.calculateSignature(itemAttributes, attributeFlags, associatedData, (PrivateKey)key);
        }
        throw new IllegalArgumentException("No integrity key provided");
    }

    byte[] calculateSignature(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData, DelegatedKey key) throws GeneralSecurityException {
        byte[] stringToSign = DynamoDBSigner.calculateStringToSign(itemAttributes, attributeFlags, associatedData);
        return key.sign(stringToSign, key.getAlgorithm());
    }

    byte[] calculateSignature(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData, SecretKey key) throws GeneralSecurityException {
        if (key instanceof DelegatedKey) {
            return this.calculateSignature(itemAttributes, attributeFlags, associatedData, (DelegatedKey)key);
        }
        byte[] stringToSign = DynamoDBSigner.calculateStringToSign(itemAttributes, attributeFlags, associatedData);
        Mac hmac = Mac.getInstance(key.getAlgorithm());
        hmac.init(key);
        hmac.update(stringToSign);
        return hmac.doFinal();
    }

    byte[] calculateSignature(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeFlags, byte[] associatedData, PrivateKey key) throws GeneralSecurityException {
        byte[] stringToSign = DynamoDBSigner.calculateStringToSign(itemAttributes, attributeFlags, associatedData);
        Signature sig = Signature.getInstance(this.signingAlgorithm);
        sig.initSign(key, this.rnd);
        sig.update(stringToSign);
        return sig.sign();
    }

    String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    private boolean safeEquals(ByteBuffer signature, byte[] calculatedSig) {
        try {
            signature.rewind();
            Mac hmac = Mac.getInstance(this.hmacComparisonKey.getAlgorithm());
            hmac.init(this.hmacComparisonKey);
            hmac.update(signature);
            byte[] signatureHash = hmac.doFinal();
            hmac.reset();
            hmac.update(calculatedSig);
            byte[] calculatedHash = hmac.doFinal();
            return MessageDigest.isEqual(signatureHash, calculatedHash);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            byte[] result = buffer.array();
            buffer.rewind();
            return result;
        }
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        buffer.rewind();
        return result;
    }
}

