/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DelegatedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.AbstractRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import com.amazonaws.util.Base64;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class WrappedRawMaterials
extends AbstractRawMaterials {
    public static final String KEY_WRAPPING_ALGORITHM = "amzn-ddb-wrap-alg";
    public static final String CONTENT_KEY_ALGORITHM = "amzn-ddb-env-alg";
    public static final String ENVELOPE_KEY = "amzn-ddb-env-key";
    private static final String DEFAULT_ALGORITHM = "AES/256";
    protected final Key wrappingKey;
    protected final Key unwrappingKey;
    private final SecretKey envelopeKey;

    public WrappedRawMaterials(Key wrappingKey, Key unwrappingKey, KeyPair signingPair) throws GeneralSecurityException {
        this(wrappingKey, unwrappingKey, signingPair, Collections.emptyMap());
    }

    public WrappedRawMaterials(Key wrappingKey, Key unwrappingKey, KeyPair signingPair, Map<String, String> description) throws GeneralSecurityException {
        super(signingPair, description);
        this.wrappingKey = wrappingKey;
        this.unwrappingKey = unwrappingKey;
        this.envelopeKey = this.initEnvelopeKey();
    }

    public WrappedRawMaterials(Key wrappingKey, Key unwrappingKey, SecretKey macKey) throws GeneralSecurityException {
        this(wrappingKey, unwrappingKey, macKey, Collections.emptyMap());
    }

    public WrappedRawMaterials(Key wrappingKey, Key unwrappingKey, SecretKey macKey, Map<String, String> description) throws GeneralSecurityException {
        super(macKey, description);
        this.wrappingKey = wrappingKey;
        this.unwrappingKey = unwrappingKey;
        this.envelopeKey = this.initEnvelopeKey();
    }

    @Override
    public SecretKey getDecryptionKey() {
        return this.envelopeKey;
    }

    @Override
    public SecretKey getEncryptionKey() {
        return this.envelopeKey;
    }

    protected SecretKey initEnvelopeKey() throws GeneralSecurityException {
        Map<String, String> description = this.getMaterialDescription();
        if (description.containsKey(ENVELOPE_KEY)) {
            if (this.unwrappingKey == null) {
                throw new IllegalStateException("No private decryption key provided.");
            }
            byte[] encryptedKey = Base64.decode((String)description.get(ENVELOPE_KEY));
            String wrappingAlgorithm = this.unwrappingKey.getAlgorithm();
            if (description.containsKey(KEY_WRAPPING_ALGORITHM)) {
                wrappingAlgorithm = description.get(KEY_WRAPPING_ALGORITHM);
            }
            return this.unwrapKey(description, encryptedKey, wrappingAlgorithm);
        }
        SecretKey key = description.containsKey(CONTENT_KEY_ALGORITHM) ? this.generateContentKey(description.get(CONTENT_KEY_ALGORITHM)) : this.generateContentKey(DEFAULT_ALGORITHM);
        String wrappingAlg = description.containsKey(KEY_WRAPPING_ALGORITHM) ? description.get(KEY_WRAPPING_ALGORITHM) : WrappedRawMaterials.getTransformation(this.wrappingKey.getAlgorithm());
        byte[] encryptedKey = this.wrapKey(key, wrappingAlg);
        description.put(ENVELOPE_KEY, Base64.encodeAsString((byte[])encryptedKey));
        description.put(CONTENT_KEY_ALGORITHM, key.getAlgorithm());
        description.put(KEY_WRAPPING_ALGORITHM, wrappingAlg);
        this.setMaterialDescription(description);
        return key;
    }

    public byte[] wrapKey(SecretKey key, String wrappingAlg) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        if (this.wrappingKey instanceof DelegatedKey) {
            return ((DelegatedKey)this.wrappingKey).wrap(key, null, wrappingAlg);
        }
        Cipher cipher = Cipher.getInstance(wrappingAlg);
        cipher.init(3, this.wrappingKey, Utils.getRng());
        byte[] encryptedKey = cipher.wrap(key);
        return encryptedKey;
    }

    protected SecretKey unwrapKey(Map<String, String> description, byte[] encryptedKey, String wrappingAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.unwrappingKey instanceof DelegatedKey) {
            return (SecretKey)((DelegatedKey)this.unwrappingKey).unwrap(encryptedKey, description.get(CONTENT_KEY_ALGORITHM), 3, null, wrappingAlgorithm);
        }
        Cipher cipher = Cipher.getInstance(wrappingAlgorithm);
        cipher.init(4, this.unwrappingKey, Utils.getRng());
        return (SecretKey)cipher.unwrap(encryptedKey, description.get(CONTENT_KEY_ALGORITHM), 3);
    }

    protected SecretKey generateContentKey(String algorithm) throws NoSuchAlgorithmException {
        String[] pieces = algorithm.split("/", 2);
        KeyGenerator kg = KeyGenerator.getInstance(pieces[0]);
        int keyLen = 0;
        if (pieces.length == 2) {
            try {
                keyLen = Integer.parseInt(pieces[1]);
            }
            catch (NumberFormatException ex) {
                keyLen = 0;
            }
        }
        if (keyLen > 0) {
            kg.init(keyLen, Utils.getRng());
        } else {
            kg.init(Utils.getRng());
        }
        return kg.generateKey();
    }

    private static String getTransformation(String algorithm) {
        if (algorithm.equalsIgnoreCase("RSA")) {
            return "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
        }
        if (algorithm.equalsIgnoreCase("AES")) {
            return "AESWrap";
        }
        return algorithm;
    }
}

