/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store.ProviderStore;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.LRUCache;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class MostRecentProvider
implements EncryptionMaterialsProvider {
    private static final long MILLI_TO_NANO = 1000000L;
    private static final long TTL_GRACE_IN_NANO = 500000000L;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ProviderStore keystore;
    private final String materialName;
    private final long ttlInNanos;
    private final LRUCache<EncryptionMaterialsProvider> cache;
    private final AtomicReference<State> state = new AtomicReference<State>(new State());

    public MostRecentProvider(ProviderStore keystore, String materialName, long ttlInMillis) {
        this.keystore = MostRecentProvider.checkNotNull(keystore, "keystore must not be null");
        this.materialName = MostRecentProvider.checkNotNull(materialName, "materialName must not be null");
        this.ttlInNanos = ttlInMillis * 1000000L;
        this.cache = new LRUCache(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        State s = this.state.get();
        if (s.provider != null && System.nanoTime() - s.lastUpdated <= this.ttlInNanos) {
            return s.provider.getEncryptionMaterials(context);
        }
        if (s.provider == null || System.nanoTime() - s.lastUpdated > this.ttlInNanos + 500000000L) {
            this.lock.lock();
        } else if (!this.lock.tryLock()) {
            return s.provider.getEncryptionMaterials(context);
        }
        try {
            EncryptionMaterialsProvider currentProvider;
            long currentVersion;
            long newVersion = this.keystore.getMaxVersion(this.materialName);
            if (newVersion < 0L) {
                currentVersion = 0L;
                currentProvider = this.keystore.getOrCreate(this.materialName, currentVersion);
                this.cache.add(Long.toString(currentVersion), currentProvider);
            } else if (newVersion != s.currentVersion) {
                currentVersion = newVersion;
                currentProvider = this.keystore.getProvider(this.materialName, currentVersion);
                this.cache.add(Long.toString(currentVersion), currentProvider);
            } else {
                currentVersion = newVersion;
                currentProvider = s.provider;
            }
            s = new State(currentProvider, currentVersion);
            this.state.set(s);
            EncryptionMaterials encryptionMaterials = s.provider.getEncryptionMaterials(context);
            return encryptionMaterials;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        long version = this.keystore.getVersionFromMaterialDescription(context.getMaterialDescription());
        EncryptionMaterialsProvider provider = this.cache.get(Long.toString(version));
        if (provider == null) {
            provider = this.keystore.getProvider(this.materialName, version);
            this.cache.add(Long.toString(version), provider);
        }
        return provider.getDecryptionMaterials(context);
    }

    @Override
    public void refresh() {
        this.state.set(new State());
        this.cache.clear();
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public long getTtlInMills() {
        return this.ttlInNanos / 1000000L;
    }

    public long getCurrentVersion() {
        return this.state.get().currentVersion;
    }

    public long getLastUpdated() {
        return this.state.get().lastUpdated / 1000000L;
    }

    private static <V> V checkNotNull(V ref, String errMsg) {
        if (ref == null) {
            throw new NullPointerException(errMsg);
        }
        return ref;
    }

    private static class State {
        public final EncryptionMaterialsProvider provider;
        public final long currentVersion;
        public final long lastUpdated;

        public State() {
            this(null, -1L);
        }

        public State(EncryptionMaterialsProvider provider, long currentVersion) {
            this.provider = provider;
            this.currentVersion = currentVersion;
            this.lastUpdated = currentVersion == -1L ? 0L : System.nanoTime();
        }
    }
}

