/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.devicefarm;

import com.amazonaws.devicefarm.DeviceFarmUploader;
import com.amazonaws.devicefarm.DeviceFarmUtils;
import com.amazonaws.devicefarm.extension.DeviceFarmExtension;
import com.amazonaws.devicefarm.extension.TestPackageProvider;
import com.amazonaws.services.devicefarm.AWSDeviceFarm;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.model.BillingMethod;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.ExecutionConfiguration;
import com.amazonaws.services.devicefarm.model.Project;
import com.amazonaws.services.devicefarm.model.ScheduleRunConfiguration;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import com.amazonaws.services.devicefarm.model.ScheduleRunTest;
import com.amazonaws.services.devicefarm.model.Upload;
import com.amazonaws.services.devicefarm.model.UploadType;
import com.android.builder.testing.api.TestServer;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.logging.Logger;

public class DeviceFarmServer
extends TestServer {
    private static final String RUNPARAM_VIDEO_RECORDING = "video_recording";
    private static final String RUNPARAM_APP_PERF_MONITORING = "app_performance_monitoring";
    private final DeviceFarmExtension extension;
    private final Logger logger;
    private final AWSDeviceFarm api;
    private final DeviceFarmUploader uploader;
    private final DeviceFarmUtils utils;

    public DeviceFarmServer(DeviceFarmExtension extension, Logger logger, AWSDeviceFarmClient deviceFarmClient) throws IOException {
        this(extension, logger, (AWSDeviceFarm)deviceFarmClient, new DeviceFarmUploader(deviceFarmClient, logger), new DeviceFarmUtils((AWSDeviceFarm)deviceFarmClient, extension));
    }

    public DeviceFarmServer(DeviceFarmExtension extension, Logger logger, AWSDeviceFarm deviceFarmClient, DeviceFarmUploader uploader, DeviceFarmUtils utils) throws IOException {
        this.extension = extension;
        this.logger = logger;
        this.api = deviceFarmClient;
        this.uploader = uploader;
        this.utils = utils;
    }

    public String getName() {
        return "devicefarm";
    }

    public void uploadApks(String variantName, File testPackage, File testedApk) {
        Project project = this.utils.findProjectByName(this.extension.getProjectName());
        this.logger.lifecycle(String.format("Using Project \"%s\", \"%s\"", project.getName(), project.getArn()));
        DevicePool devicePool = this.utils.findDevicePoolByName(project, this.extension.getDevicePool());
        this.logger.lifecycle(String.format("Using Device Pool \"%s\", \"%s\"", devicePool.getName(), devicePool.getArn()));
        String appArn = this.uploader.upload(testedApk == null ? testPackage : testedApk, project, UploadType.ANDROID_APP).getArn();
        this.logger.lifecycle(String.format("Will test app in  \"%s\", \"%s\"", testedApk == null ? testPackage.getName() : testedApk.getName(), appArn));
        Collection<Upload> auxApps = this.uploadAuxApps(project);
        String extraDataArn = this.uploadExtraDataZip(project);
        ScheduleRunTest runTest = new ScheduleRunTest().withParameters(this.extension.getTest().getTestParameters()).withType(this.extension.getTest().getTestType()).withFilter(this.extension.getTest().getFilter()).withTestPackageArn(this.uploadTestPackageIfNeeded(project, testPackage));
        runTest.addParametersEntry(RUNPARAM_VIDEO_RECORDING, Boolean.toString(this.extension.getVideoRecording()));
        runTest.addParametersEntry(RUNPARAM_APP_PERF_MONITORING, Boolean.toString(this.extension.getPerformanceMonitoring()));
        ExecutionConfiguration executionConfiguration = new ExecutionConfiguration().withJobTimeoutMinutes(Integer.valueOf(this.extension.getExecutionTimeoutMinutes()));
        ScheduleRunConfiguration configuration = new ScheduleRunConfiguration().withAuxiliaryApps(this.getAuxAppArns(auxApps)).withExtraDataPackageArn(extraDataArn).withLocale(this.extension.getDeviceState().getLocale().toString()).withLocation(this.extension.getDeviceState().getLocation()).withBillingMethod(this.extension.isMetered() ? BillingMethod.METERED : BillingMethod.UNMETERED).withRadios(this.extension.getDeviceState().getRadios());
        ScheduleRunRequest request = new ScheduleRunRequest().withAppArn(appArn).withConfiguration(configuration).withDevicePoolArn(devicePool.getArn()).withProjectArn(project.getArn()).withTest(runTest).withExecutionConfiguration(executionConfiguration).withName(String.format("%s (Gradle)", testedApk == null ? testPackage.getName() : testedApk.getName()));
        ScheduleRunResult response = this.api.scheduleRun(request);
        this.logger.lifecycle(String.format("View the %s run in the AWS Device Farm Console: %s", runTest.getType(), this.utils.getRunUrlFromArn(response.getRun().getArn())));
    }

    private String uploadTestPackageIfNeeded(Project project, File testPackage) {
        String testArtifactsArn = null;
        if (this.extension.getTest() instanceof TestPackageProvider) {
            TestPackageProvider testPackageProvider = (TestPackageProvider)((Object)this.extension.getTest());
            File testArtifacts = testPackageProvider.resolveTestPackage(testPackage);
            testArtifactsArn = this.uploader.upload(testArtifacts, project, testPackageProvider.getTestPackageUploadType()).getArn();
            this.logger.lifecycle(String.format("Will run tests in %s, %s", testArtifacts.getName(), testArtifactsArn));
        }
        return testArtifactsArn;
    }

    private Collection<Upload> uploadAuxApps(Project project) {
        Collection<Upload> auxApps = this.uploader.batchUpload(this.extension.getDeviceState().getAuxiliaryApps(), project, UploadType.ANDROID_APP);
        if (auxApps == null || auxApps.size() == 0) {
            return null;
        }
        for (Upload auxApp : auxApps) {
            this.logger.lifecycle(String.format("Will install additional app %s, %s", auxApp.getName(), auxApp.getArn()));
        }
        return auxApps;
    }

    private String uploadExtraDataZip(Project project) {
        File extraDataZip = this.extension.getDeviceState().getExtraDataZipFile();
        String extraDataArn = null;
        if (extraDataZip != null) {
            extraDataArn = this.uploader.upload(extraDataZip, project, UploadType.EXTERNAL_DATA).getArn();
            this.logger.lifecycle(String.format("Will copy data from zip %s, %s", extraDataZip, extraDataArn));
        }
        return extraDataArn;
    }

    private List<String> getAuxAppArns(Collection<Upload> auxUploads) {
        ArrayList auxAppArns = Lists.newArrayList();
        if (auxUploads == null || auxUploads.size() == 0) {
            return auxAppArns;
        }
        for (Upload auxApp : auxUploads) {
            auxAppArns.add(auxApp.getArn());
        }
        return auxAppArns;
    }

    public boolean isConfigured() {
        boolean configured = this.extension.isValid();
        this.logger.lifecycle(String.format("AWS Device Farm configuration is %s", configured ? "VALID" : "NOT VALID"));
        return configured;
    }
}

