/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.ArtifactNamespace;
import com.amazonaws.services.codebuild.model.ArtifactPackaging;
import com.amazonaws.services.codebuild.model.ArtifactsType;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.SourceType;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.google.inject.Inject;
import enums.CodeBuildRegions;
import enums.EncryptionAlgorithm;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CodeBuildStep
extends AbstractStepImpl {
    private String credentialsType;
    private String credentialsId;
    private String proxyHost;
    private String proxyPort;
    private String awsAccessKey;
    private String awsSecretKey;
    private String awsSessionToken;
    private String region;
    private String projectName;
    private String sourceControlType;
    private String sourceVersion;
    private String sseAlgorithm;
    private String gitCloneDepthOverride;
    private String artifactTypeOverride;
    private String artifactLocationOverride;
    private String artifactNameOverride;
    private String artifactNamespaceOverride;
    private String artifactPackagingOverride;
    private String artifactPathOverride;
    private String environmentTypeOverride;
    private String imageOverride;
    private String computeTypeOverride;
    private String certificateOverride;
    private String cacheTypeOverride;
    private String cacheLocationOverride;
    private String serviceRoleOverride;
    private String privilegedModeOverride;
    private String sourceTypeOverride;
    private String sourceLocationOverride;
    private String insecureSslOverride;
    private String envVariables;
    private String envParameters;
    private String buildSpecFile;
    private String buildTimeoutOverride;

    @DataBoundSetter
    public void setCredentialsType(String credentialsType) {
        this.credentialsType = credentialsType;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @DataBoundSetter
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @DataBoundSetter
    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    @DataBoundSetter
    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    @DataBoundSetter
    public void setAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = region;
    }

    @DataBoundConstructor
    public CodeBuildStep(String projectName) {
        this.projectName = projectName;
    }

    @DataBoundSetter
    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    @DataBoundSetter
    public void setSseAlgorithm(String sseAlgorithm) {
        this.sseAlgorithm = sseAlgorithm;
    }

    @DataBoundSetter
    public void setSourceControlType(String sourceControlType) {
        this.sourceControlType = sourceControlType;
    }

    @DataBoundSetter
    public void setGitCloneDepthOverride(String gitCloneDepthOverride) {
        this.gitCloneDepthOverride = gitCloneDepthOverride;
    }

    @DataBoundSetter
    public void setArtifactTypeOverride(String artifactTypeOverride) {
        this.artifactTypeOverride = artifactTypeOverride;
    }

    @DataBoundSetter
    public void setArtifactLocationOverride(String artifactLocationOverride) {
        this.artifactLocationOverride = artifactLocationOverride;
    }

    @DataBoundSetter
    public void setArtifactNameOverride(String artifactNameOverride) {
        this.artifactNameOverride = artifactNameOverride;
    }

    @DataBoundSetter
    public void setArtifactNamespaceOverride(String artifactNamespaceOverride) {
        this.artifactNamespaceOverride = artifactNamespaceOverride;
    }

    @DataBoundSetter
    public void setArtifactPackagingOverride(String artifactPackagingOverride) {
        this.artifactPackagingOverride = artifactPackagingOverride;
    }

    @DataBoundSetter
    public void setArtifactPathOverride(String artifactPathOverride) {
        this.artifactPathOverride = artifactPathOverride;
    }

    @DataBoundSetter
    public void setEnvironmentTypeOverride(String environmentTypeOverride) {
        this.environmentTypeOverride = environmentTypeOverride;
    }

    @DataBoundSetter
    public void setImageOverride(String imageOverride) {
        this.imageOverride = imageOverride;
    }

    @DataBoundSetter
    public void setComputeTypeOverride(String computeTypeOverride) {
        this.computeTypeOverride = computeTypeOverride;
    }

    @DataBoundSetter
    public void setCertificateOverride(String certificateOverride) {
        this.certificateOverride = certificateOverride;
    }

    @DataBoundSetter
    public void setCacheTypeOverride(String cacheTypeOverride) {
        this.cacheTypeOverride = cacheTypeOverride;
    }

    @DataBoundSetter
    public void setCacheLocationOverride(String cacheLocationOverride) {
        this.cacheLocationOverride = cacheLocationOverride;
    }

    @DataBoundSetter
    public void setServiceRoleOverride(String serviceRoleOverride) {
        this.serviceRoleOverride = serviceRoleOverride;
    }

    @DataBoundSetter
    public void setPrivilegedModeOverride(String privilegedModeOverride) {
        this.privilegedModeOverride = privilegedModeOverride;
    }

    @DataBoundSetter
    public void setSourceTypeOverride(String sourceTypeOverride) {
        this.sourceTypeOverride = sourceTypeOverride;
    }

    @DataBoundSetter
    public void setSourceLocationOverride(String sourceLocationOverride) {
        this.sourceLocationOverride = sourceLocationOverride;
    }

    @DataBoundSetter
    public void setInsecureSslOverride(String insecureSslOverride) {
        this.insecureSslOverride = insecureSslOverride;
    }

    @DataBoundSetter
    public void setEnvVariables(String envVariables) {
        this.envVariables = envVariables;
    }

    @DataBoundSetter
    public void setEnvParameters(String envParameters) {
        this.envParameters = envParameters;
    }

    @DataBoundSetter
    public void setBuildSpecFile(String buildSpecFile) {
        this.buildSpecFile = buildSpecFile;
    }

    @DataBoundSetter
    public void setBuildTimeoutOverride(String buildTimeoutOverride) {
        this.buildTimeoutOverride = buildTimeoutOverride;
    }

    public String getCredentialsType() {
        return this.credentialsType;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourceControlType() {
        return this.sourceControlType;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public String getGitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public String getArtifactTypeOverride() {
        return this.artifactTypeOverride;
    }

    public String getArtifactLocationOverride() {
        return this.artifactLocationOverride;
    }

    public String getArtifactNameOverride() {
        return this.artifactNameOverride;
    }

    public String getArtifactNamespaceOverride() {
        return this.artifactNamespaceOverride;
    }

    public String getArtifactPackagingOverride() {
        return this.artifactPackagingOverride;
    }

    public String getArtifactPathOverride() {
        return this.artifactPathOverride;
    }

    public String getEnvironmentTypeOverride() {
        return this.environmentTypeOverride;
    }

    public String getImageOverride() {
        return this.imageOverride;
    }

    public String getComputeTypeOverride() {
        return this.computeTypeOverride;
    }

    public String getCertificateOverride() {
        return this.certificateOverride;
    }

    public String getCacheTypeOverride() {
        return this.cacheTypeOverride;
    }

    public String getCacheLocationOverride() {
        return this.cacheLocationOverride;
    }

    public String getServiceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public String getPrivilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public String getSourceTypeOverride() {
        return this.sourceTypeOverride;
    }

    public String getSourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public String getInsecureSslOverride() {
        return this.insecureSslOverride;
    }

    public String getEnvVariables() {
        return this.envVariables;
    }

    public String getEnvParameters() {
        return this.envParameters;
    }

    public String getBuildSpecFile() {
        return this.buildSpecFile;
    }

    public String getBuildTimeoutOverride() {
        return this.buildTimeoutOverride;
    }

    public static final class CodeBuildExecution
    extends AbstractSynchronousNonBlockingStepExecution<CodeBuildResult> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient CodeBuildStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;

        protected CodeBuildResult run() throws Exception {
            CodeBuilder builder = (CodeBuilder)((Object)new CodeBuilder(this.step.getCredentialsType(), this.step.getCredentialsId(), this.step.getProxyHost(), this.step.getProxyPort(), this.step.getAwsAccessKey(), this.step.getAwsSecretKey(), this.step.getAwsSessionToken(), this.step.getRegion(), this.step.getProjectName(), this.step.sourceVersion, this.step.sseAlgorithm, this.step.sourceControlType, this.step.gitCloneDepthOverride, this.step.artifactTypeOverride, this.step.artifactLocationOverride, this.step.artifactNameOverride, this.step.artifactNamespaceOverride, this.step.artifactPackagingOverride, this.step.artifactPathOverride, this.step.envVariables, this.step.envParameters, this.step.buildSpecFile, this.step.buildTimeoutOverride, this.step.sourceTypeOverride, this.step.sourceLocationOverride, this.step.environmentTypeOverride, this.step.imageOverride, this.step.computeTypeOverride, this.step.cacheTypeOverride, this.step.cacheLocationOverride, this.step.certificateOverride, this.step.serviceRoleOverride, this.step.insecureSslOverride, this.step.privilegedModeOverride).readResolve());
            builder.perform(this.run, this.ws, this.launcher, this.listener);
            CodeBuildResult result = builder.getCodeBuildResult();
            if (result.getStatus().equals("FAILURE") || result.getStatus().equals("STOPPED")) {
                throw new CodeBuildException(result);
            }
            return result;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            throw new NotSerializableException(((Object)((Object)this)).getClass().getName());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(CodeBuildExecution.class);
        }

        public String getFunctionName() {
            return "awsCodeBuild";
        }

        public String getDisplayName() {
            return "Invoke an AWS CodeBuild build";
        }

        public ListBoxModel doFillGitCloneDepthOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("1");
            selections.add("5");
            selections.add("25");
            selections.add("Full");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillPrivilegedModeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("False");
            selections.add("True");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillInsecureSslOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("False");
            selections.add("True");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactsType t : ArtifactsType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactNamespaceOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactNamespace t : ArtifactNamespace.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactPackagingOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactPackaging t : ArtifactPackaging.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillSourceTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (SourceType t : SourceType.values()) {
                if (t.equals((Object)SourceType.CODEPIPELINE)) continue;
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillComputeTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ComputeType t : ComputeType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillCacheTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (CacheType t : CacheType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillEnvironmentTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EnvironmentType t : EnvironmentType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel selections = new ListBoxModel();
            for (CodeBuildRegions r : CodeBuildRegions.values()) {
                selections.add(r.toString());
            }
            return selections;
        }

        public ListBoxModel doFillCredentialsIdItems() {
            ListBoxModel selections = new ListBoxModel();
            SystemCredentialsProvider s = SystemCredentialsProvider.getInstance();
            HashSet<String> displayCredentials = new HashSet<String>();
            for (Credentials c : s.getCredentials()) {
                if (!(c instanceof CodeBuildCredentials)) continue;
                displayCredentials.add(((CodeBuildCredentials)c).getId());
            }
            Jenkins instance = Jenkins.getInstance();
            if (instance != null) {
                List folders = instance.getAllItems(Folder.class);
                for (Folder folder : folders) {
                    List creds = CredentialsProvider.lookupCredentials(Credentials.class, (Item)folder);
                    for (Credentials cred : creds) {
                        if (!(cred instanceof CodeBuildCredentials)) continue;
                        displayCredentials.add(((CodeBuildCredentials)cred).getId());
                    }
                }
            }
            for (String credString : displayCredentials) {
                selections.add(credString);
            }
            return selections;
        }

        public ListBoxModel doFillSseAlgorithmItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EncryptionAlgorithm e : EncryptionAlgorithm.values()) {
                selections.add(e.toString());
            }
            return selections;
        }
    }
}

