/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import androidx.core.util.ObjectsCompat;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;

public final class UploadOptions {
    private final String bucket;
    private final ObjectMetadata metadata;
    private final CannedAccessControlList cannedAcl;
    private final TransferListener listener;

    public UploadOptions(Builder builder) {
        this.bucket = builder.bucket;
        this.metadata = builder.metadata;
        this.cannedAcl = builder.cannedAcl;
        this.listener = builder.listener;
    }

    public String getBucket() {
        return this.bucket;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public TransferListener getTransferListener() {
        return this.listener;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "UploadOptions{bucket='" + this.bucket + '\'' + ", metadata=" + this.metadata + ", cannedAcl=" + (Object)((Object)this.cannedAcl) + ", listener=" + this.listener + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UploadOptions that = (UploadOptions)obj;
        return ObjectsCompat.equals((Object)this.bucket, (Object)that.bucket) && ObjectsCompat.equals((Object)this.metadata, (Object)that.metadata) && this.cannedAcl == that.cannedAcl && ObjectsCompat.equals((Object)this.listener, (Object)that.listener);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.bucket, this.metadata, this.cannedAcl, this.listener});
    }

    public static final class Builder {
        private String bucket;
        private ObjectMetadata metadata;
        private CannedAccessControlList cannedAcl;
        private TransferListener listener;

        private Builder() {
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder objectMetadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        public Builder transferListener(TransferListener listener) {
            this.listener = listener;
            return this;
        }

        public UploadOptions build() {
            return new UploadOptions(this);
        }
    }
}

