/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

class TransferStatusUpdater {
    private static final Log LOGGER = LogFactory.getLog(TransferStatusUpdater.class);
    private static final HashSet<TransferState> STATES_NOT_TO_NOTIFY = new HashSet<TransferState>(Arrays.asList(TransferState.PART_COMPLETED, TransferState.PENDING_CANCEL, TransferState.PENDING_PAUSE, TransferState.PENDING_NETWORK_DISCONNECT));
    static final Map<Integer, List<TransferListener>> LISTENERS = new ConcurrentHashMap<Integer, List<TransferListener>>(){};
    private final Map<Integer, TransferRecord> transfers;
    private static TransferDBUtil dbUtil;
    private final Handler mainHandler;
    private Context context;
    private static TransferStatusUpdater transferStatusUpdater;
    static final String TEMP_FILE_PREFIX = "aws-s3-d861b25a-1edf-11eb-adc1-0242ac120002";

    TransferStatusUpdater(TransferDBUtil dbUtilInstance, Context context) {
        dbUtil = dbUtilInstance;
        this.context = context;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.transfers = new ConcurrentHashMap<Integer, TransferRecord>();
    }

    public static synchronized TransferStatusUpdater getInstance(Context context) {
        if (transferStatusUpdater == null) {
            dbUtil = new TransferDBUtil(context);
            transferStatusUpdater = new TransferStatusUpdater(dbUtil, context);
        }
        return transferStatusUpdater;
    }

    synchronized Map<Integer, TransferRecord> getTransfers() {
        return Collections.unmodifiableMap(this.transfers);
    }

    synchronized void addTransfer(TransferRecord transfer) {
        this.transfers.put(transfer.id, transfer);
    }

    synchronized TransferRecord getTransfer(int id) {
        return this.transfers.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeTransfer(int id) {
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            LISTENERS.remove(id);
        }
        this.transfers.remove(id);
    }

    synchronized void removeTransferRecordFromDB(int id) {
        String path;
        String fileName;
        TransferRecord transferRecord = dbUtil.getTransferById(id);
        if (transferRecord != null && (fileName = new File(path = transferRecord.file).getName()).startsWith(TEMP_FILE_PREFIX)) {
            new File(path).delete();
        }
        S3ClientReference.remove(id);
        dbUtil.deleteTransferRecords(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateState(final int id, final TransferState newState) {
        boolean shouldNotNotify = STATES_NOT_TO_NOTIFY.contains((Object)newState);
        TransferRecord transfer = this.transfers.get(id);
        if (transfer == null) {
            if (dbUtil.updateState(id, newState) == 0) {
                LOGGER.warn((Object)("Failed to update the status of transfer " + id));
            }
        } else {
            shouldNotNotify |= newState.equals((Object)transfer.state);
            transfer.state = newState;
            if (dbUtil.updateTransferRecord(transfer) == 0) {
                LOGGER.warn((Object)("Failed to update the status of transfer " + id));
            }
        }
        if (shouldNotNotify) {
            return;
        }
        if (TransferState.COMPLETED.equals((Object)newState)) {
            this.removeTransferRecordFromDB(id);
        }
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list != null && !list.isEmpty()) {
                for (final TransferListener l : list) {
                    if (l instanceof TransferObserver.TransferStatusListener) {
                        l.onStateChanged(id, newState);
                        continue;
                    }
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            l.onStateChanged(id, newState);
                        }
                    });
                }
                if (TransferState.isFinalState(newState)) {
                    list.clear();
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 26) {
            boolean stopTransferService = true;
            for (TransferRecord record : this.transfers.values()) {
                if (TransferState.isFinalState(record.state)) continue;
                stopTransferService = false;
                LOGGER.info((Object)"Transfers still pending, keeping TransferService running.");
                break;
            }
            if (stopTransferService) {
                LOGGER.info((Object)"All transfers in final state. Stopping TransferService");
                this.context.stopService(new Intent(this.context, TransferService.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateProgress(final int id, final long bytesCurrent, final long bytesTotal, boolean notifyListener) {
        TransferRecord transfer = this.transfers.get(id);
        if (transfer != null) {
            transfer.bytesCurrent = bytesCurrent;
            transfer.bytesTotal = bytesTotal;
        }
        dbUtil.updateBytesTransferred(id, bytesCurrent);
        if (!notifyListener) {
            return;
        }
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list == null || list.isEmpty()) {
                return;
            }
            for (final TransferListener l : list) {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        l.onProgressChanged(id, bytesCurrent, bytesTotal);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void throwError(final int id, final Exception e) {
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list == null || list.isEmpty()) {
                return;
            }
            for (final TransferListener l : list) {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        l.onError(id, e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clear() {
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            LISTENERS.clear();
        }
        this.transfers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list == null) {
                list = new CopyOnWriteArrayList<TransferListener>();
                list.add(listener);
                LISTENERS.put(id, list);
            } else if (!list.contains(listener)) {
                list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list == null || list.isEmpty()) {
                return;
            }
            list.remove(listener);
        }
    }

    synchronized ProgressListener newProgressListener(int id) {
        TransferRecord transfer = this.getTransfer(id);
        if (transfer == null) {
            LOGGER.info((Object)("TransferStatusUpdater doesn't track the transfer: " + id));
            throw new IllegalArgumentException("transfer " + id + " doesn't exist");
        }
        LOGGER.info((Object)("Creating a new progress listener for transfer: " + id));
        return new TransferProgressListener(transfer);
    }

    private class TransferProgressListener
    implements ProgressListener {
        private final TransferRecord transfer;
        private long bytesTransferredSoFar;

        public TransferProgressListener(TransferRecord transfer) {
            this.transfer = transfer;
        }

        public synchronized void progressChanged(ProgressEvent progressEvent) {
            if (32 == progressEvent.getEventCode()) {
                LOGGER.info((Object)"Reset Event triggered. Resetting the bytesCurrent to 0.");
                this.bytesTransferredSoFar = 0L;
            } else {
                this.bytesTransferredSoFar += progressEvent.getBytesTransferred();
                if (this.bytesTransferredSoFar > this.transfer.bytesCurrent) {
                    this.transfer.bytesCurrent = this.bytesTransferredSoFar;
                    TransferStatusUpdater.this.updateProgress(this.transfer.id, this.transfer.bytesCurrent, this.transfer.bytesTotal, true);
                }
            }
        }
    }
}

